/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.datafixers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jurassicraft.server.datafixers.DataFixerFactory;

public class JurassiCraftDataFixers {
    private static final int DATAFIXER_VERSION = 5;
    private static final ModFixs modFixs = FMLCommonHandler.instance().getDataFixer().init("jurassicraft", 5);

    public static void init() {
        ArrayList tileEntityList = Lists.newArrayList((Object[])new String[]{"tour_rail", "cultivate_bottom", "cleaning_station", "fossil_grinder", "dna_sequencer", "dna_synthesizer", "embryonic_machine", "embryo_calcification_machi", "dna_extractor", "dna_combinator_hybridizer", "incubator", "display_block", "feeder", "bug_crate", "tileentityelectricfence", "tileentityelectricpole", "tileentityelectricbase"});
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new DataFixerFactory(1, nbt -> {
            ResourceLocation teLoc = new ResourceLocation(nbt.func_74779_i("id"));
            String path = teLoc.func_110623_a();
            if (teLoc.func_110624_b().equals("minecraft") && tileEntityList.contains(path)) {
                nbt.func_74778_a("id", "jurassicraft:" + path);
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(2, nbt -> {
            if ("jurassicraft:iron_nugget".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "minecraft:iron_nugget");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(3, nbt -> {
            if ("jurassicraft:display_block_item".equals(nbt.func_74779_i("id"))) {
                short meta = nbt.func_74765_d("Damage");
                int dinosaurID = meta >> 4 & 0xFFFF;
                int gender = meta >> 1 & 7;
                boolean isSkeleton = (meta & 1) == 1;
                nbt.func_74777_a("Damage", (short)(dinosaurID << 9 | 0 | gender << 1 | (isSkeleton ? 1 : 0)));
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(4, nbt -> {
            if ("jurassicraft:display_block_item".equals(nbt.func_74779_i("id"))) {
                short meta = nbt.func_74765_d("Damage");
                int dinosaurID = meta >> 9;
                int gender = meta >> 1 & 3;
                byte skeletonVariant = (byte)(meta >> 4 & 0xF);
                boolean isSkeleton = (meta & 1) == 1;
                nbt.func_74777_a("Damage", (short)(dinosaurID << 2 | (gender == 1 ? 1 : 0) << 1 | (isSkeleton ? 1 : 0)));
                nbt.func_74774_a("Type", skeletonVariant);
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new DataFixerFactory(4, nbt -> {
            if ("jurassicraft:display_block".equals(nbt.func_74779_i("id"))) {
                nbt.func_74757_a("IsFossile", nbt.func_74767_n("IsMale"));
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(4, nbt -> {
            if ("jurassicraft:jeep_wrangler".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:vehicle_item");
                nbt.func_74777_a("Damage", (short)1);
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(4, nbt -> {
            if ("jurassicraft:helicopter".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:vehicle_item");
                nbt.func_74777_a("Damage", (short)2);
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(4, nbt -> {
            if ("jurassicraft:ford_explorer".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:vehicle_item");
                nbt.func_74777_a("Damage", (short)0);
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new DataFixerFactory(2, compound -> {
            if ("jurassicraft.mural".equals(compound.func_74779_i("id"))) {
                compound.func_74778_a("id", "jurassicraft:entities.mural");
            }
            return compound;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:gracilaria_seaweed".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:gracilaria_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:enallhelia".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:enallhelia_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:cladochonus".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:cladochonus_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:hippurites_radiosus".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:hippurites_radiosus_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:lithostrotion".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:lithostrotion_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:aulopora".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:aulopora_coral");
            }
            return nbt;
        }));
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DataFixerFactory(5, nbt -> {
            if ("jurassicraft:stylophyllopsis".equals(nbt.func_74779_i("id"))) {
                nbt.func_74778_a("id", "jurassicraft:stylophyllopsis_coral");
            }
            return nbt;
        }));
    }
}

