/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.dinosaur;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.Diet;
import org.jurassicraft.server.entity.OverlayType;
import org.jurassicraft.server.entity.SleepTime;
import org.jurassicraft.server.entity.ai.util.MovementType;
import org.jurassicraft.server.entity.dinosaur.MixosaurusEntity;
import org.jurassicraft.server.period.TimePeriod;

public class MixosaurusDinosaur
extends Dinosaur {
    private static final HashMap<String, Float> offsets = new HashMap<String, Float>(){
        {
            this.put("jawUpper5", Float.valueOf(0.001f));
            this.put("jawLowerBase2", Float.valueOf(0.001f));
            this.put("tailFlipper5", Float.valueOf(0.005f));
            this.put("tailFluke4", Float.valueOf(0.005f));
        }
    };
    public static final double SPEED = 0.2;

    @Override
    protected DinosaurMetadata buildMetadata() {
        return new DinosaurMetadata(new ResourceLocation("jurassicraft", "mixosaurus")).setEntity(MixosaurusEntity.class, MixosaurusEntity::new).setDinosaurType(Dinosaur.DinosaurType.SCARED).setTimePeriod(TimePeriod.TRIASSIC).setIncubationTime(3200).setEggColorMale(4940385, 1912631).setEggColorFemale(5530973, 5530973).setHealth(8.0, 36.0).setFlee(true).setSpeed(0.08, 0.2).setAttackSpeed(1.5).setStrength(0.5, 3.0).setMaximumAge(this.fromDays(70)).setEyeHeight(0.35f, 1.8f).setSizeX(0.1f, 1.0f).setSizeY(0.08f, 0.6f).setStorage(9).setDiet(Diet.PISCIVORE.get()).setSleepTime(SleepTime.DIURNAL).setBirthType(Dinosaur.BirthType.LIVE_BIRTH).setBones("tail_fluke", "tail_vertebrae", "ribcage", "skull", "teeth", "hind_flipper_bones", "front_flipper_bones").setHeadCubeName("head").setScale(0.7f, 0.22f).setOverlays(OverlayType.EYE, OverlayType.MOUTH, OverlayType.TEETH, OverlayType.EYELID, OverlayType.NOSTRILS).setMaxHerdSize(12).setOffset(0.0f, 0.6f, 0.0f).setAttackBias(600.0).setMarineAnimal(true).setMovementType(MovementType.NEAR_SURFACE).setSkeletonPoses("idle", "dead", "attack").setBreeding(true, 1, 3, 40, true, false).setRandomFlock(false).setOffsetCubes(offsets).setRecipe(new String[][]{{"tail_fluke", "tail_vertebrae", "ribcage", "skull"}, {"", "", "", "teeth"}, {"hind_flipper_bones", "hind_flipper_bones", "front_flipper_bones", "front_flipper_bones"}}).setSpawn(10, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WATER);
    }

    @Override
    public void applyMeatEffect(EntityPlayer player, boolean cooked) {
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1));
    }
}

