/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AnimalMetadata {
    protected final ResourceLocation identifier;
    protected HashMap<String, Float> offsetCubes = new HashMap();
    private Class<? extends EntityLivingBase> entityClass;
    private Function<World, EntityLivingBase> entityConstructor;
    private int primaryEggColor;
    private int secondaryEggColor;

    public AnimalMetadata(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public AnimalMetadata setAnimalEntity(Class<? extends EntityLivingBase> clazz, Function<World, EntityLivingBase> constructor) {
        this.entityClass = clazz;
        this.entityConstructor = constructor;
        return this;
    }

    public AnimalMetadata setAnimalOffsetCubes(HashMap<String, Float> cubes) {
        this.offsetCubes = cubes;
        return this;
    }

    public HashMap<String, Float> getOffsetCubes() {
        return this.offsetCubes;
    }

    public int getEggPrimaryColor() {
        return this.primaryEggColor;
    }

    public int getEggSecondaryColor() {
        return this.secondaryEggColor;
    }

    public AnimalMetadata setEggColor(int primary, int secondary) {
        this.primaryEggColor = primary;
        this.secondaryEggColor = secondary;
        return this;
    }

    public EntityLivingBase construct(World world) {
        return this.entityConstructor.apply(world);
    }

    public Class<? extends EntityLivingBase> getAnimalClass() {
        return this.entityClass;
    }
}

