/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.commons.lang3.ArrayUtils;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.config.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.AllosaurusDinosaur;
import org.jurassicraft.server.dinosaur.ApatosaurusDinosaur;
import org.jurassicraft.server.dinosaur.BaryonyxDinosaur;
import org.jurassicraft.server.dinosaur.BrachiosaurusDinosaur;
import org.jurassicraft.server.dinosaur.CarnotaurusDinosaur;
import org.jurassicraft.server.dinosaur.CeratosaurusDinosaur;
import org.jurassicraft.server.dinosaur.ChilesaurusDinosaur;
import org.jurassicraft.server.dinosaur.CoelacanthDinosaur;
import org.jurassicraft.server.dinosaur.CoelophysisDinosaur;
import org.jurassicraft.server.dinosaur.CompsognathusDinosaur;
import org.jurassicraft.server.dinosaur.CorythosaurusDinosaur;
import org.jurassicraft.server.dinosaur.CryolophosaurusDinosaur;
import org.jurassicraft.server.dinosaur.DeinonychusDinosaur;
import org.jurassicraft.server.dinosaur.DilophosaurusDinosaur;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.dinosaur.DryosaurusDinosaur;
import org.jurassicraft.server.dinosaur.EdmontosaurusDinosaur;
import org.jurassicraft.server.dinosaur.GallimimusDinosaur;
import org.jurassicraft.server.dinosaur.GiganotosaurusDinosaur;
import org.jurassicraft.server.dinosaur.HadrosaurusDinosaur;
import org.jurassicraft.server.dinosaur.HerrerasaurusDinosaur;
import org.jurassicraft.server.dinosaur.HomalocephaleDinosaur;
import org.jurassicraft.server.dinosaur.HuayangosaurusDinosaur;
import org.jurassicraft.server.dinosaur.HypsilophodonDinosaur;
import org.jurassicraft.server.dinosaur.LeaellynasauraDinosaur;
import org.jurassicraft.server.dinosaur.LeedsichthysDinosaur;
import org.jurassicraft.server.dinosaur.LesothosaurusDinosaur;
import org.jurassicraft.server.dinosaur.MachairasaurusDinosaur;
import org.jurassicraft.server.dinosaur.MegapiranhaDinosaur;
import org.jurassicraft.server.dinosaur.MetriacanthosaurusDinosaur;
import org.jurassicraft.server.dinosaur.MicroceratusDinosaur;
import org.jurassicraft.server.dinosaur.MicroraptorDinosaur;
import org.jurassicraft.server.dinosaur.MixosaurusDinosaur;
import org.jurassicraft.server.dinosaur.MussaurusDinosaur;
import org.jurassicraft.server.dinosaur.OrnitholestesDinosaur;
import org.jurassicraft.server.dinosaur.OrnithomimusDinosaur;
import org.jurassicraft.server.dinosaur.PachycephalosaurusDinosaur;
import org.jurassicraft.server.dinosaur.ParasaurolophusDinosaur;
import org.jurassicraft.server.dinosaur.ProceratosaurusDinosaur;
import org.jurassicraft.server.dinosaur.ProcompsognathusDinosaur;
import org.jurassicraft.server.dinosaur.SegisaurusDinosaur;
import org.jurassicraft.server.dinosaur.SpinosaurusDinosaur;
import org.jurassicraft.server.dinosaur.StegosaurusDinosaur;
import org.jurassicraft.server.dinosaur.StyracosaurusDinosaur;
import org.jurassicraft.server.dinosaur.SuchomimusDinosaur;
import org.jurassicraft.server.dinosaur.TitanisDinosaur;
import org.jurassicraft.server.dinosaur.TriceratopsDinosaur;
import org.jurassicraft.server.dinosaur.TroodonDinosaur;
import org.jurassicraft.server.dinosaur.TyrannosaurusDinosaur;
import org.jurassicraft.server.dinosaur.VelociraptorDinosaur;
import org.jurassicraft.server.entity.Animal;
import org.jurassicraft.server.entity.AnimalMetadata;
import org.jurassicraft.server.entity.DartEntity;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GoatAnimal;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.item.AttractionSignEntity;
import org.jurassicraft.server.entity.item.DinosaurEggEntity;
import org.jurassicraft.server.entity.item.MuralEntity;
import org.jurassicraft.server.entity.item.PaddockSignEntity;
import org.jurassicraft.server.entity.vehicle.FordExplorerEntity;
import org.jurassicraft.server.entity.vehicle.JeepWranglerEntity;
import org.jurassicraft.server.entity.vehicle.TransportHelicopterEntity;
import org.jurassicraft.server.message.SpecialAnimationMessage;
import org.jurassicraft.server.period.TimePeriod;

public class EntityHandler {
    public static final Dinosaur ALLOSAURUS = new AllosaurusDinosaur();
    public static final Dinosaur APATOSAURUS = new ApatosaurusDinosaur();
    public static final Dinosaur BARYONYX = new BaryonyxDinosaur();
    public static final Dinosaur BRACHIOSAURUS = new BrachiosaurusDinosaur();
    public static final Dinosaur CARNOTAURUS = new CarnotaurusDinosaur();
    public static final Dinosaur CERATOSAURUS = new CeratosaurusDinosaur();
    public static final Dinosaur CHILESAURUS = new ChilesaurusDinosaur();
    public static final Dinosaur COELACANTH = new CoelacanthDinosaur();
    public static final Dinosaur COELOPHYSIS = new CoelophysisDinosaur();
    public static final Dinosaur COMPSOGNATHUS = new CompsognathusDinosaur();
    public static final Dinosaur CORYTHOSAURUS = new CorythosaurusDinosaur();
    public static final Dinosaur CRYOLOPHOSAURUS = new CryolophosaurusDinosaur();
    public static final Dinosaur DEINONYCHUS = new DeinonychusDinosaur();
    public static final Dinosaur DILOPHOSAURUS = new DilophosaurusDinosaur();
    public static final Dinosaur DRYOSAURUS = new DryosaurusDinosaur();
    public static final Dinosaur EDMONTOSAURUS = new EdmontosaurusDinosaur();
    public static final Dinosaur GALLIMIMUS = new GallimimusDinosaur();
    public static final Dinosaur GIGANOTOSAURUS = new GiganotosaurusDinosaur();
    public static final Dinosaur HADROSAURUS = new HadrosaurusDinosaur();
    public static final Dinosaur HERRERASAURUS = new HerrerasaurusDinosaur();
    public static final Dinosaur HOMALOCEPHALE = new HomalocephaleDinosaur();
    public static final Dinosaur HUAYANGOSAURUS = new HuayangosaurusDinosaur();
    public static final Dinosaur HYPSILOPHODON = new HypsilophodonDinosaur();
    public static final Dinosaur LEAELLYNASAURA = new LeaellynasauraDinosaur();
    public static final Dinosaur LEEDSICHTHYS = new LeedsichthysDinosaur();
    public static final Dinosaur LESOTHOSAURUS = new LesothosaurusDinosaur();
    public static final Dinosaur ORNITHOLESTES = new OrnitholestesDinosaur();
    public static final Dinosaur ORNITHOMIMUS = new OrnithomimusDinosaur();
    public static final Dinosaur PACHYCEPHALOSAURUS = new PachycephalosaurusDinosaur();
    public static final Dinosaur PARASAUROLOPHUS = new ParasaurolophusDinosaur();
    public static final Dinosaur PROCERATOSAURUS = new ProceratosaurusDinosaur();
    public static final Dinosaur PROCOMPSOGNATHUS = new ProcompsognathusDinosaur();
    public static final Dinosaur SEGISAURUS = new SegisaurusDinosaur();
    public static final Dinosaur SPINOSAURUS = new SpinosaurusDinosaur();
    public static final Dinosaur STEGOSAURUS = new StegosaurusDinosaur();
    public static final Dinosaur STYRACOSAURUS = new StyracosaurusDinosaur();
    public static final Dinosaur SUCHOMIMUS = new SuchomimusDinosaur();
    public static final Dinosaur MACHAIRASAURUS = new MachairasaurusDinosaur();
    public static final Dinosaur METRIACANTHOSAURUS = new MetriacanthosaurusDinosaur();
    public static final Dinosaur MEGAPIRANHA = new MegapiranhaDinosaur();
    public static final Dinosaur MICRORAPTOR = new MicroraptorDinosaur();
    public static final Dinosaur MICROCERATUS = new MicroceratusDinosaur();
    public static final Dinosaur MIXOSAURUS = new MixosaurusDinosaur();
    public static final Dinosaur MUSSAURUS = new MussaurusDinosaur();
    public static final Dinosaur TITANIS = new TitanisDinosaur();
    public static final Dinosaur TRICERATOPS = new TriceratopsDinosaur();
    public static final Dinosaur TROODON = new TroodonDinosaur();
    public static final Dinosaur TYRANNOSAURUS = new TyrannosaurusDinosaur();
    public static final Dinosaur VELOCIRAPTOR = new VelociraptorDinosaur();
    public static final Animal GOAT = new GoatAnimal();
    private static final Map<Integer, Dinosaur> DINOSAURS = new HashMap<Integer, Dinosaur>();
    private static final Map<Integer, Animal> ANIMALS = new HashMap<Integer, Animal>();
    private static final Map<Dinosaur, Integer> DINOSAUR_IDS = new HashMap<Dinosaur, Integer>();
    private static final Map<Animal, Integer> ANIMAL_IDS = new HashMap<Animal, Integer>();
    private static final HashMap<TimePeriod, List<Dinosaur>> DINOSAUR_PERIODS = new HashMap();
    private static int entityId;
    private static ProgressManager.ProgressBar dinosaurProgress;
    private static ProgressManager.ProgressBar animalProgress;
    private static int highestAnimalID;
    private static int highestDinosaurID;

    public static List<Dinosaur> getMarineCreatures() {
        ArrayList<Dinosaur> marineDinosaurs = new ArrayList<Dinosaur>();
        for (Dinosaur dino : EntityHandler.getRegisteredDinosaurs()) {
            if (!dino.getMetadata().isMarineCreature() || dino instanceof Hybrid) continue;
            marineDinosaurs.add(dino);
        }
        return marineDinosaurs;
    }

    public static void init() {
        EntityHandler.registerDinosaur(0, VELOCIRAPTOR);
        EntityHandler.registerDinosaur(1, COELACANTH);
        EntityHandler.registerDinosaur(2, MICRORAPTOR);
        EntityHandler.registerDinosaur(3, BRACHIOSAURUS);
        EntityHandler.registerDinosaur(4, MUSSAURUS);
        EntityHandler.registerDinosaur(5, DRYOSAURUS);
        EntityHandler.registerDinosaur(7, DILOPHOSAURUS);
        EntityHandler.registerDinosaur(9, GALLIMIMUS);
        EntityHandler.registerDinosaur(13, PARASAUROLOPHUS);
        EntityHandler.registerDinosaur(19, TRICERATOPS);
        EntityHandler.registerDinosaur(20, TYRANNOSAURUS);
        EntityHandler.registerDinosaur(21, PROCOMPSOGNATHUS);
        EntityHandler.registerDinosaur(22, SPINOSAURUS);
        EntityHandler.registerDinosaur(23, STEGOSAURUS);
        EntityHandler.registerDinosaur(24, SEGISAURUS);
        EntityHandler.registerDinosaur(25, CERATOSAURUS);
        EntityHandler.registerDinosaur(26, CORYTHOSAURUS);
        EntityHandler.registerDinosaur(27, HERRERASAURUS);
        EntityHandler.registerDinosaur(28, PROCERATOSAURUS);
        EntityHandler.registerDinosaur(29, PACHYCEPHALOSAURUS);
        EntityHandler.registerDinosaur(30, METRIACANTHOSAURUS);
        EntityHandler.registerDinosaur(31, ALLOSAURUS);
        EntityHandler.registerDinosaur(32, HUAYANGOSAURUS);
        EntityHandler.registerDinosaur(33, ORNITHOLESTES);
        EntityHandler.registerDinosaur(34, DEINONYCHUS);
        EntityHandler.registerDinosaur(35, BARYONYX);
        EntityHandler.registerDinosaur(36, APATOSAURUS);
        EntityHandler.registerDinosaur(37, LEAELLYNASAURA);
        EntityHandler.registerDinosaur(38, COMPSOGNATHUS);
        EntityHandler.registerDinosaur(39, HADROSAURUS);
        EntityHandler.registerDinosaur(40, CARNOTAURUS);
        EntityHandler.registerDinosaur(41, HOMALOCEPHALE);
        EntityHandler.registerDinosaur(42, SUCHOMIMUS);
        EntityHandler.registerDinosaur(43, TROODON);
        EntityHandler.registerDinosaur(44, MACHAIRASAURUS);
        EntityHandler.registerDinosaur(45, TITANIS);
        EntityHandler.registerDinosaur(46, HYPSILOPHODON);
        EntityHandler.registerDinosaur(47, ORNITHOMIMUS);
        EntityHandler.registerDinosaur(48, CRYOLOPHOSAURUS);
        EntityHandler.registerDinosaur(49, COELOPHYSIS);
        EntityHandler.registerDinosaur(51, CHILESAURUS);
        EntityHandler.registerDinosaur(52, MEGAPIRANHA);
        EntityHandler.registerDinosaur(53, STYRACOSAURUS);
        EntityHandler.registerDinosaur(54, MIXOSAURUS);
        EntityHandler.registerDinosaur(55, LEEDSICHTHYS);
        EntityHandler.registerDinosaur(56, EDMONTOSAURUS);
        EntityHandler.registerDinosaur(57, MICROCERATUS);
        EntityHandler.registerDinosaur(58, LESOTHOSAURUS);
        EntityHandler.registerDinosaur(59, GIGANOTOSAURUS);
        EntityHandler.registerAnimal(0, GOAT);
        dinosaurProgress = ProgressManager.push((String)"Loading dinosaurs", (int)DINOSAURS.size());
        EntityHandler.initDinosaurs();
        ProgressManager.pop((ProgressManager.ProgressBar)dinosaurProgress);
        animalProgress = ProgressManager.push((String)"Loading animals", (int)ANIMALS.size());
        EntityHandler.initAnimals();
        ProgressManager.pop((ProgressManager.ProgressBar)animalProgress);
        EntityHandler.registerEntity(AttractionSignEntity.class, "Attraction Sign");
        EntityHandler.registerEntity(PaddockSignEntity.class, "Paddock Sign");
        EntityHandler.registerEntity(MuralEntity.class, "Mural");
        EntityHandler.registerEntity(VenomEntity.class, "Venom");
        EntityHandler.registerEntity(JeepWranglerEntity.class, "Jeep Wrangler");
        EntityHandler.registerEntity(FordExplorerEntity.class, "Ford Explorer");
        EntityHandler.registerEntity(DartEntity.class, "Tranquilizer Dart");
        EntityHandler.registerEntity(DinosaurEggEntity.class, "Dinosaur Egg");
        EntityHandler.registerEntity(TransportHelicopterEntity.class, "Helicopter base");
    }

    private static void initDinosaurs() {
        for (Dinosaur dinosaur : DINOSAURS.values()) {
            boolean canSpawn;
            dinosaurProgress.step(dinosaur.getIdentifier().toString());
            dinosaur.init();
            boolean bl = canSpawn = !(dinosaur instanceof Hybrid) && dinosaur.shouldRegister();
            if (canSpawn) {
                TimePeriod period = dinosaur.getMetadata().getPeriod();
                List periods = DINOSAUR_PERIODS.computeIfAbsent(period, k -> new LinkedList());
                periods.add(dinosaur);
            }
            Class<? extends DinosaurEntity> clazz = dinosaur.getMetadata().getDinosaurClass();
            EntityHandler.registerDinosaurEntity(clazz, dinosaur.getIdentifier());
            EntityHandler.addSpawn(canSpawn, clazz, dinosaur);
        }
    }

    private static void initAnimals() {
        for (Animal animal : ANIMALS.values()) {
            animalProgress.step(animal.getIdentifier().toString());
            AnimalMetadata meta = animal.getMetadata();
            Class<? extends EntityLivingBase> clazz = meta.getAnimalClass();
            EntityHandler.registerAnimalEntity(clazz, animal.getIdentifier(), meta.getEggPrimaryColor(), meta.getEggSecondaryColor());
        }
    }

    private static void addSpawn(boolean canSpawn, Class clazz, Dinosaur dinosaur) {
        if (canSpawn && JurassiCraftConfig.ENTITIES.naturalSpawning_D) {
            DinosaurMetadata metadata = dinosaur.getMetadata();
            EntityRegistry.addSpawn((Class)clazz, (int)metadata.getSpawnChance(), (int)1, (int)Math.min(6, metadata.getMaxHerdSize() / 2), (EnumCreatureType)(metadata.isMarineCreature() ? EnumCreatureType.WATER_CREATURE : EnumCreatureType.CREATURE), (Biome[])metadata.getSpawnBiomes());
            EntitySpawnPlacementRegistry.setPlacementType((Class)clazz, (EntityLiving.SpawnPlacementType)(metadata.isMarineCreature() ? EntityLiving.SpawnPlacementType.IN_WATER : EntityLiving.SpawnPlacementType.ON_GROUND));
        }
    }

    public static void reinitSpawns() {
        for (Dinosaur dinosaur : DINOSAURS.values()) {
            DinosaurMetadata metadata = dinosaur.getMetadata();
            Class<? extends DinosaurEntity> clazz = metadata.getDinosaurClass();
            EntityRegistry.removeSpawn(clazz, (EnumCreatureType)(metadata.isMarineCreature() ? EnumCreatureType.WATER_CREATURE : EnumCreatureType.CREATURE), (Biome[])metadata.getSpawnBiomes());
            boolean canSpawn = !(dinosaur instanceof Hybrid) && dinosaur.shouldRegister();
            EntityHandler.addSpawn(canSpawn, clazz, dinosaur);
        }
    }

    private static void registerDinosaurEntity(Class<? extends Entity> entity, ResourceLocation identifier) {
        String name = identifier.func_110624_b() + "." + identifier.func_110623_a();
        ResourceLocation registryName = new ResourceLocation("jurassicraft:entities." + identifier.func_110623_a());
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entity, (String)name, (int)entityId++, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true);
    }

    private static void registerAnimalEntity(Class<? extends EntityLivingBase> entity, ResourceLocation identifier, int primary, int secondary) {
        String name = identifier.func_110624_b() + "." + identifier.func_110623_a();
        ResourceLocation registryName = new ResourceLocation("jurassicraft:entities." + identifier.func_110623_a());
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entity, (String)name, (int)entityId++, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true, (int)primary, (int)secondary);
    }

    private static void registerEntity(Class<? extends Entity> entity, String name) {
        String formattedName = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        ResourceLocation registryName = new ResourceLocation("jurassicraft:entities." + formattedName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entity, (String)("jurassicraft." + formattedName), (int)entityId++, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true);
    }

    private static void registerEntity(Class<? extends Entity> entity, String name, int primary, int secondary) {
        String formattedName = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        ResourceLocation registryName = new ResourceLocation("jurassicraft:entities." + formattedName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entity, (String)("jurassicraft." + formattedName), (int)entityId++, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true, (int)primary, (int)secondary);
    }

    public static void registerAnimal(int id, Animal animal) {
        if (id > highestAnimalID) {
            highestAnimalID = id;
        }
        ANIMALS.put(id, animal);
        ANIMAL_IDS.put(animal, id);
    }

    public static void registerDinosaur(int id, Dinosaur dinosaur) {
        if (id > highestDinosaurID) {
            highestDinosaurID = id;
        }
        DINOSAURS.put(id, dinosaur);
        DINOSAUR_IDS.put(dinosaur, id);
    }

    public static Dinosaur getDinosaurById(int id) {
        Dinosaur dinosaur = DINOSAURS.get(id);
        return dinosaur != null ? dinosaur : EntityHandler.getDinosaurById(0);
    }

    public static int getDinosaurId(Dinosaur dinosaur) {
        return DINOSAUR_IDS.get(dinosaur);
    }

    public static Animal getAnimalById(int id) {
        Animal animal = ANIMALS.get(id);
        return animal != null ? animal : EntityHandler.getAnimalById(0);
    }

    public static int getAnimalId(Animal animal) {
        return ANIMAL_IDS.get(animal);
    }

    public static List<Dinosaur> getDinosaursFromAmber() {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>();
        for (Dinosaur dinosaur : EntityHandler.getRegisteredDinosaurs()) {
            if (dinosaur.getMetadata().isMarineCreature() || dinosaur instanceof Hybrid) continue;
            dinosaurs.add(dinosaur);
        }
        return dinosaurs;
    }

    public static Map<Integer, Dinosaur> getDinosaurs() {
        return DINOSAURS;
    }

    public static List<Dinosaur> getRegisteredDinosaurs() {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>();
        for (Dinosaur dinosaur : DINOSAURS.values()) {
            if (!dinosaur.shouldRegister()) continue;
            dinosaurs.add(dinosaur);
        }
        return dinosaurs;
    }

    public static List<Dinosaur> getPrehistoricDinosaurs() {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>();
        for (Dinosaur dinosaur : DINOSAURS.values()) {
            if (!dinosaur.shouldRegister() || dinosaur instanceof Hybrid) continue;
            dinosaurs.add(dinosaur);
        }
        return dinosaurs;
    }

    public static List<Dinosaur> getDinosaursFromPeriod(TimePeriod period) {
        return DINOSAUR_PERIODS.get((Object)period);
    }

    public static Animal getAnimalByClass(Class<? extends EntityLivingBase> clazz) {
        for (Animal animal : ANIMALS.values()) {
            if (!animal.getMetadata().getAnimalClass().equals(clazz)) continue;
            return animal;
        }
        return null;
    }

    public static int getHighestAnimalID() {
        return highestAnimalID;
    }

    public static Dinosaur getDinosaurByClass(Class<? extends DinosaurEntity> clazz) {
        for (Dinosaur dinosaur : DINOSAURS.values()) {
            if (!dinosaur.getMetadata().getDinosaurClass().equals(clazz)) continue;
            return dinosaur;
        }
        return null;
    }

    public static int getHighestDinosaurID() {
        return highestDinosaurID;
    }

    public static <T extends Entity> void sendSpecialAnimationMessage(T entity, Animation animation, byte variant) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        for (EntityPlayer trackingPlayer : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            JurassiCraft.NETWORK_WRAPPER.sendTo((IMessage)new SpecialAnimationMessage(entity.func_145782_y(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation), variant), (EntityPlayerMP)trackingPlayer);
        }
    }
}

