/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Set;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.model.animation.PoseHandler;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.entity.Animal;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.ai.SmartBodyHelper;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.food.FoodType;
import org.jurassicraft.server.item.ItemHandler;

public class GoatEntity
extends EntityAnimal
implements Animatable,
IEntityAdditionalSpawnData {
    public static final PoseHandler<GoatEntity> BILLY_POSE_HANDLER = new PoseHandler(new ResourceLocation("jurassicraft", "goat_billy"), Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}), EntityHandler.GOAT.getMetadata());
    public static final PoseHandler<GoatEntity> KID_POSE_HANDLER = new PoseHandler(new ResourceLocation("jurassicraft", "goat_kid"), Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}), EntityHandler.GOAT.getMetadata());
    public static final PoseHandler<GoatEntity> NANNY_POSE_HANDLER = new PoseHandler(new ResourceLocation("jurassicraft", "goat_nanny"), Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}), EntityHandler.GOAT.getMetadata());
    private static final DataParameter<Boolean> WATCHER_IS_RUNNING = EntityDataManager.func_187226_a(GoatEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    protected Animal animal;
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private boolean billy;
    private Variant variant = Variant.JURASSIC_PARK;
    private boolean milked;
    private boolean inLava;
    private final byte animationVariant = 0;

    public GoatEntity(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.2f);
        this.field_70138_W = 1.0f;
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    protected EntityBodyHelper func_184650_s() {
        return new SmartBodyHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, (Set)Sets.newHashSet(FoodHelper.getFoodItems(FoodType.PLANT))));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 6.0f, 1.0, (double)1.6f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.animal = EntityHandler.getAnimalByClass(this.getClass());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void addVariant(Animation animation, byte variant) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_IS_RUNNING, (Object)false);
    }

    public EntityAgeable func_90011_a(EntityAgeable mate) {
        GoatEntity entity = new GoatEntity(this.field_70170_p);
        entity.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        return entity;
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public byte getAnimationVariant(Animation animation) {
        return 0;
    }

    @Override
    public boolean isMoving() {
        float deltaX = (float)(this.field_70165_t - this.field_70169_q);
        float deltaZ = (float)(this.field_70161_v - this.field_70166_s);
        return deltaX * deltaX + deltaZ * deltaZ > 0.001f;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean isSwimming() {
        return (this.func_70090_H() || this.func_180799_ab()) && !this.field_70122_E;
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_RUNNING);
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return growthStage == GrowthStage.ADULT;
    }

    @Override
    public boolean isMarineCreature() {
        return false;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    @Override
    public boolean isSleeping() {
        return false;
    }

    @Override
    public boolean inWater() {
        return this.func_70090_H();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 10 == 0) {
            this.inLava = this.func_180799_ab();
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(EntityAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_RUNNING, (Object)((double)this.func_70689_ay() > this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() ? 1 : 0));
        }
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage(), this.getAnimationVariant(newAnimation));
            EntityHandler.sendSpecialAnimationMessage(this, newAnimation, (byte)0);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return this.func_70631_g_() ? GrowthStage.INFANT : GrowthStage.ADULT;
    }

    public PoseHandler getPoseHandler() {
        return this.func_70631_g_() ? KID_POSE_HANDLER : (this.billy ? BILLY_POSE_HANDLER : NANNY_POSE_HANDLER);
    }

    public Type getType() {
        return this.func_70631_g_() ? Type.KID : (this.billy ? Type.BILLY : Type.NANNY);
    }

    public void func_70642_aH() {
        super.func_70642_aH();
        if (this.getAnimation() == EntityAnimation.IDLE.get()) {
            this.setAnimation(EntityAnimation.SPEAK.get());
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.GOAT_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundHandler.GOAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.GOAT_DEATH;
    }

    protected float func_175134_bD() {
        return 0.62f;
    }

    public void func_70615_aA() {
        super.func_70615_aA();
        this.milked = false;
        this.setAnimation(EntityAnimation.EATING.get());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(stack == null || stack.func_77973_b() != Items.field_151133_ar || player.field_71075_bZ.field_75098_d || this.func_70631_g_() || this.milked || this.billy)) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
            }
            this.milked = true;
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.billy = this.field_70146_Z.nextBoolean();
        this.variant = Variant.values()[this.field_70146_Z.nextInt(Variant.values().length)];
        return super.func_180482_a(difficulty, data);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Billy", this.billy);
        compound.func_74774_a("Variant", (byte)this.variant.ordinal());
        compound.func_74757_a("Milked", this.milked);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.billy = compound.func_74767_n("Billy");
        this.variant = Variant.values()[compound.func_74771_c("Variant")];
        this.milked = compound.func_74767_n("Milked");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.billy);
        buffer.writeByte(this.variant.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.billy = additionalData.readBoolean();
        this.variant = Variant.values()[additionalData.readByte()];
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && FoodHelper.isFoodType(stack.func_77973_b(), FoodType.PLANT);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Items.field_151116_aA, this.field_70146_Z.nextInt(2) + 1);
        if (this.field_70146_Z.nextBoolean()) {
            this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1, this.field_70146_Z.nextBoolean() ? EnumDyeColor.BROWN.func_176765_a() : EnumDyeColor.WHITE.func_176765_a()), 0.0f);
        }
        this.func_145779_a((Item)(this.func_70027_ad() ? ItemHandler.GOAT_COOKED : ItemHandler.GOAT_RAW), this.field_70146_Z.nextInt(2) + 1);
    }

    protected float func_70599_aP() {
        return super.func_70599_aP() * 0.8f;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public int func_70641_bl() {
        return 3;
    }

    public int func_70627_aG() {
        return 300;
    }

    public boolean func_70878_b(EntityAnimal other) {
        if (other instanceof GoatEntity) {
            GoatEntity goat = (GoatEntity)other;
            return goat.getType() == Type.NANNY && this.getType() == Type.BILLY || goat.getType() == Type.BILLY && this.getType() == Type.NANNY;
        }
        return super.func_70878_b(other);
    }

    @Override
    public HashMap<Animation, Byte> getVariants() {
        return new HashMap<Animation, Byte>();
    }

    @Override
    public void setAnimationWithVariant(Animation newAnimation, byte variant) {
        this.setAnimation(newAnimation);
    }

    @Override
    public Class getEntityClass() {
        return this.getClass();
    }

    public static enum Variant {
        JURASSIC_WORLD,
        JURASSIC_PARK,
        JPOG;

    }

    public static enum Type {
        BILLY,
        NANNY,
        KID;

    }
}

