/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;

public class InventoryDinosaur
implements IInventory {
    private final DinosaurEntity entity;
    private final NonNullList<ItemStack> inventory;

    public InventoryDinosaur(DinosaurEntity entity) {
        this.entity = entity;
        this.inventory = NonNullList.func_191197_a((int)entity.getDinosaur().getMetadata().getStorage(), (Object)ItemStack.field_190927_a);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(slotTag);
            nbttaglist.func_74742_a((NBTBase)slotTag);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound slotTag = nbttaglist.func_150305_b(i);
            ItemStack stack = new ItemStack(slotTag);
            int j = slotTag.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.size()) continue;
            this.func_70299_a(j, stack);
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(index)).func_190916_E() <= count) {
                ItemStack itemstack = (ItemStack)this.inventory.get(index);
                this.func_70299_a(index, ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(index)).func_190916_E() == 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.entity.field_70128_L && (double)player.func_70032_d((Entity)this.entity) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public String func_70005_c_() {
        return this.entity.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.entity.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.entity.func_145748_c_();
    }

    public void dropItems(World world, Random rand) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            float offsetX = rand.nextFloat() * 0.8f + 0.1f;
            float offsetY = rand.nextFloat() * 0.8f + 0.1f;
            float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem itemEntity = new EntityItem(world, this.entity.field_70165_t + (double)offsetX, this.entity.field_70163_u + (double)offsetY, this.entity.field_70161_v + (double)offsetZ, new ItemStack(itemstack.func_77973_b(), itemstack.func_190916_E(), itemstack.func_77952_i()));
            float multiplier = 0.05f;
            itemEntity.field_70159_w = (float)rand.nextGaussian() * multiplier;
            itemEntity.field_70181_x = (float)rand.nextGaussian() * multiplier + 0.2f;
            itemEntity.field_70179_y = (float)rand.nextGaussian() * multiplier;
            world.func_72838_d((Entity)itemEntity);
            itemstack.func_190918_g(itemstack.func_190916_E());
        }
    }

    public boolean func_191420_l() {
        return false;
    }
}

