/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.util.GameRuleHandler;

public class MetabolismContainer {
    private final int maxEnergy;
    private final int maxWater;
    private int energy;
    private int water;
    private final float contactDistance = 3.0f;
    private final float metabolismDangerPercent = 20.0f;
    private final DinosaurEntity dinosaur;

    public MetabolismContainer(DinosaurEntity dinosaurIn) {
        this.dinosaur = dinosaurIn;
        this.maxEnergy = (int)(this.dinosaur.getDinosaur().getMetadata().getAdultHealth() / 10.0 * 24000.0);
        this.maxWater = (int)(this.dinosaur.getDinosaur().getMetadata().getAdultHealth() / 10.0 * 24000.0);
        this.energy = this.maxEnergy;
        this.water = this.maxWater;
    }

    public void updateMetabolism() {
        if (this.dinosaur.isAlive() && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p)) {
            this.decreaseEnergy(1);
            this.decreaseWater(2);
        }
    }

    public void decreaseEnergy(int amount) {
        this.energy -= amount;
        this.energy = Math.max(0, this.energy);
        if (this.isStarving() && this.dinosaur.field_70173_aa % 40 == 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76366_f, this.dinosaur.func_110138_aP() * 0.05f);
        }
    }

    public void decreaseWater(int amount) {
        this.water -= amount;
        this.water = Math.max(0, this.water);
        if (this.isDehydrated() && this.dinosaur.field_70173_aa % 40 == 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76366_f, this.dinosaur.func_110138_aP() * 0.05f);
        }
    }

    public void increaseEnergy(int amount) {
        this.setEnergy(this.energy + amount);
    }

    public void increaseWater(int amount) {
        this.setWater(this.water + amount);
    }

    public void eat(int amount) {
        this.increaseEnergy(amount);
    }

    public boolean shouldUseFeeder() {
        return (double)this.energy < (double)this.maxEnergy * 0.7 || !GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p);
    }

    public boolean shouldTargetCarcass() {
        return (double)this.energy < (double)this.maxEnergy * 0.75 || !GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p);
    }

    public boolean isHungry() {
        return (double)this.energy < (double)this.maxEnergy * 0.8 || !GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p);
    }

    public boolean isThirsty() {
        return (double)this.water < (double)this.maxWater * 0.7 || !GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p);
    }

    public boolean isStarving() {
        return (double)this.energy < (double)((float)this.maxEnergy * 0.2f);
    }

    public boolean isDehydrated() {
        return (double)this.water < (double)((float)this.maxWater * 0.2f);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.water = nbt.func_74762_e("Water");
        this.energy = nbt.func_74762_e("Energy");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Water", this.water);
        nbt.func_74768_a("Energy", this.energy);
    }

    public int getWater() {
        return this.water;
    }

    public void setWater(int waterAmount) {
        this.water = Math.min(waterAmount, this.maxWater);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energyAmount) {
        this.energy = Math.min(energyAmount, this.maxEnergy);
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getMaxWater() {
        return this.maxWater;
    }

    public float getContactDistance() {
        return 3.0f;
    }
}

