/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.MoveUnderwaterEntityAI;

public abstract class SwimmingDinosaurEntity
extends DinosaurEntity {
    public SwimmingDinosaurEntity(World world) {
        super(world);
        this.field_70765_h = new SwimmingMoveHelper(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MoveUnderwaterEntityAI(this));
        this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, world);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--air);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H() && !this.isCarcass()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.7;
            this.field_70181_x *= 0.7;
            this.field_70179_y *= 0.7;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public int func_70646_bf() {
        return 180;
    }

    public boolean func_70090_H() {
        return this.field_70171_ac;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    static class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final SwimmingDinosaurEntity swimmer;

        public SwimmingMoveHelper(SwimmingDinosaurEntity swimmer) {
            super((EntityLiving)swimmer);
            this.swimmer = swimmer;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.swimmer.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.swimmer.field_70165_t;
                double d1 = this.field_75647_c - this.swimmer.field_70163_u;
                double d2 = this.field_75644_d - this.swimmer.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.swimmer.field_70761_aq = this.swimmer.field_70177_z = this.func_75639_a(this.swimmer.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.swimmer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.swimmer.func_70659_e(this.swimmer.func_70689_ay() + (f1 - this.swimmer.func_70689_ay()) * 0.125f);
                double d5 = Math.cos(this.swimmer.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.swimmer.field_70177_z * ((float)Math.PI / 180));
                double d4 = Math.sin((double)(this.swimmer.field_70173_aa + this.swimmer.func_145782_y()) * 0.75) * 0.05;
                this.swimmer.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.swimmer.field_70181_x += (double)this.swimmer.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.swimmer.func_70671_ap();
                double d7 = this.swimmer.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.swimmer.func_70047_e() + this.swimmer.field_70163_u + d1 / d3;
                double d9 = this.swimmer.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.swimmer.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.swimmer.func_70659_e(0.0f);
            }
        }
    }
}

