/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;

public class DinosaurWanderEntityAI
extends EntityAIBase {
    private static final ThreadPoolExecutor tpeWander = new ThreadPoolExecutor(0, 15, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    protected DinosaurEntity entity;
    protected int executionChance;
    private volatile double xPosition = 0.0;
    private volatile double yPosition = 0.0;
    private volatile double zPosition = 0.0;
    private final double speed;
    private boolean mustUpdate;
    private volatile boolean should = false;
    private volatile boolean started = false;

    public DinosaurWanderEntityAI(DinosaurEntity creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(4);
    }

    public boolean func_75250_a() {
        if (!this.mustUpdate && this.innerShouldStopExcecuting()) {
            return false;
        }
        if (this.outterShouldExecute()) {
            if (this.started) {
                return false;
            }
            if (tpeWander.getActiveCount() < 14) {
                try {
                    tpeWander.execute(new ThreadRunnable(this, this.entity){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            World world = this.entity.field_70170_p;
                            synchronized (world) {
                                this.ai.started = true;
                                block3: for (int i = 0; i < 100; ++i) {
                                    Vec3d vec = DinosaurWanderEntityAI.this.getWanderPosition();
                                    if (vec == null) continue;
                                    for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(vec.func_72441_c(0.0, 1.0, 0.0)), (BlockPos)new BlockPos(vec.func_72441_c(1.0, 1.0, 1.0)))) {
                                        if (this.entity.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a) continue;
                                        continue block3;
                                    }
                                    this.ai.xPosition = vec.field_72450_a;
                                    this.ai.yPosition = vec.field_72448_b;
                                    this.ai.zPosition = vec.field_72449_c;
                                    this.ai.mustUpdate = false;
                                    this.ai.should = true;
                                }
                                this.ai.started = false;
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        return this.should;
    }

    protected boolean innerShouldStopExcecuting() {
        return this.entity.func_70681_au().nextInt(this.executionChance) != 0;
    }

    protected boolean outterShouldExecute() {
        return this.entity.func_70661_as().func_75500_f() && this.entity.func_70638_az() == null;
    }

    protected Vec3d getWanderPosition() {
        return RandomPositionGenerator.func_191377_b((EntityCreature)this.entity, (int)10, (int)10);
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() && !this.entity.func_70090_H();
    }

    public void func_75249_e() {
        try {
            this.entity.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.should = false;
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int chance) {
        this.executionChance = chance;
    }

    abstract class ThreadRunnable
    implements Runnable {
        final DinosaurEntity entity;
        final DinosaurWanderEntityAI ai;

        ThreadRunnable(DinosaurWanderEntityAI wanderAI, DinosaurEntity entity) {
            this.ai = wanderAI;
            this.entity = entity;
        }
    }
}

