/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.util.GameRuleHandler;

public class Herd
implements Iterable<DinosaurEntity> {
    public Set<DinosaurEntity> members = new HashSet<DinosaurEntity>();
    public DinosaurEntity leader;
    public State state = State.IDLE;
    public int stateTicks;
    public Set<EntityLivingBase> enemies = new HashSet<EntityLivingBase>();
    public boolean fleeing;
    private Vec3d center;
    private float moveX;
    private float moveZ;
    private final Random random = new Random();
    private final Dinosaur herdType;
    private int nextMemberCheck;
    private int failedPathTicks;

    public Herd(DinosaurEntity leader) {
        this.herdType = leader.getDinosaur();
        this.members.add(leader);
        this.leader = leader;
        this.resetStateTicks();
    }

    public void update() {
        if (this.leader == null || this.leader.isCarcass() || this.leader.field_70128_L) {
            this.updateLeader();
        }
        if (this.stateTicks > 0 && this.failedPathTicks < this.members.size() * 2) {
            --this.stateTicks;
        } else {
            this.state = this.herdType.getMetadata().shouldRandomlyFlock() ? (this.state == State.MOVING ? State.IDLE : State.MOVING) : State.IDLE;
            this.resetStateTicks();
            this.enemies.clear();
            this.fleeing = false;
        }
        if (this.leader != null) {
            if (this.leader.shouldSleep()) {
                this.state = State.IDLE;
                this.resetStateTicks();
            }
            this.center = this.getCenterPosition();
            if (this.enemies.size() > 0) {
                if (this.fleeing) {
                    this.state = State.MOVING;
                    float angle = 0.0f;
                    for (EntityLivingBase attacker : this.enemies) {
                        angle = (float)((double)angle + MathHelper.func_181159_b((double)(this.center.field_72449_c - attacker.field_70161_v), (double)(this.center.field_72450_a - attacker.field_70165_t)));
                    }
                    this.moveX = -MathHelper.func_76134_b((float)(angle /= (float)this.enemies.size()));
                    this.moveZ = MathHelper.func_76126_a((float)angle);
                    this.normalizeMovement();
                } else {
                    this.state = State.IDLE;
                }
            } else {
                this.fleeing = false;
            }
            LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
            for (DinosaurEntity entity : this) {
                if (!(entity.func_70092_e(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c) > 2048.0)) continue;
                remove.add(entity);
            }
            for (DinosaurEntity entity : remove) {
                this.splitHerd(entity);
                if (entity != this.leader) continue;
                this.updateLeader();
            }
            if (this.leader == null) {
                return;
            }
            boolean attemptedPath = false;
            int failedPaths = 0;
            for (DinosaurEntity entity : this) {
                if (this.enemies.isEmpty() || this.fleeing) {
                    boolean canMove;
                    double speed;
                    if (entity.getMetabolism().isHungry() || entity.getMetabolism().isThirsty() || entity.func_70610_aX() || entity.func_70090_H() || !this.fleeing && !entity.func_70661_as().func_75500_f() || this.state != State.MOVING && this.random.nextInt(50) != 0) continue;
                    float entityMoveX = this.moveX * 8.0f;
                    float entityMoveZ = this.moveZ * 8.0f;
                    float centerDistance = (float)Math.abs(entity.func_70011_f(this.center.field_72450_a, entity.field_70163_u, this.center.field_72449_c));
                    if (this.fleeing) {
                        centerDistance *= 4.0f;
                    }
                    if (centerDistance > 0.0f) {
                        entityMoveX = (float)((double)entityMoveX + (this.center.field_72450_a - entity.field_70165_t) / (double)centerDistance);
                        entityMoveZ = (float)((double)entityMoveZ + (this.center.field_72449_c - entity.field_70161_v) / (double)centerDistance);
                    }
                    for (DinosaurEntity other : this) {
                        float separation;
                        float distance;
                        if (other == entity || !((distance = (float)entity.func_70068_e((Entity)other)) < (separation = entity.field_70130_N * 1.5f + 1.5f))) continue;
                        float scale = distance / separation;
                        entityMoveX = (float)((double)entityMoveX + (entity.field_70165_t - other.field_70165_t) / (double)scale);
                        entityMoveZ = (float)((double)entityMoveZ + (entity.field_70161_v - other.field_70161_v) / (double)scale);
                    }
                    double navigateX = entity.field_70165_t + (double)entityMoveX;
                    double navigateZ = entity.field_70161_v + (double)entityMoveZ;
                    Dinosaur dinosaur = entity.getDinosaur();
                    double d = speed = this.state == State.IDLE ? 0.8 : dinosaur.getMetadata().getFlockSpeed();
                    if (this.fleeing && dinosaur.getMetadata().getAttackSpeed() > speed) {
                        speed = dinosaur.getMetadata().getAttackSpeed();
                    }
                    if (entity.disableHerdingTicks > 0 || entity.func_70638_az() != null || this.members.size() <= 1 && !this.fleeing) continue;
                    BlockPos navigatePos = entity.field_70170_p.func_175645_m(new BlockPos(navigateX, 0.0, navigateZ)).func_177984_a();
                    if (entity.func_70661_as().func_75505_d() != null && !entity.func_70661_as().func_75505_d().func_75879_b()) {
                        PathPoint finalPoint = entity.func_70661_as().func_75505_d().func_75870_c();
                        if (navigatePos.func_185332_f(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c) < 25.0) continue;
                    }
                    attemptedPath = true;
                    if (!(entity.func_174831_c(navigatePos) > 16.0) || entity.func_70610_aX() || (canMove = entity.func_70661_as().func_75492_a((double)navigatePos.func_177958_n(), (double)navigatePos.func_177956_o(), (double)navigatePos.func_177952_p(), speed))) continue;
                    ++failedPaths;
                    continue;
                }
                if (this.fleeing || entity.func_70638_az() != null && this.random.nextInt(20) != 0 || this.enemies.size() <= 0 || entity.getAgePercentage() <= 50) continue;
                int index = this.random.nextInt(this.enemies.size());
                Iterator<EntityLivingBase> enemyIterator = this.enemies.iterator();
                for (int i = 0; i < index; ++i) {
                    enemyIterator.next();
                }
                entity.func_70624_b(enemyIterator.next());
            }
            if (attemptedPath) {
                if (failedPaths > this.members.size() / 4) {
                    this.moveX = -this.moveX + (this.random.nextFloat() - 0.5f) * 0.1f;
                    this.moveZ = -this.moveZ + (this.random.nextFloat() - 0.5f) * 0.1f;
                    ++this.failedPathTicks;
                    this.normalizeMovement();
                } else if (this.failedPathTicks > 0) {
                    --this.failedPathTicks;
                }
            }
            LinkedList<EntityLivingBase> invalidEnemies = new LinkedList<EntityLivingBase>();
            for (EntityLivingBase enemy : this.enemies) {
                if (!(enemy.field_70128_L || enemy instanceof DinosaurEntity && ((DinosaurEntity)enemy).isCarcass() || enemy instanceof EntityPlayer && ((EntityPlayer)enemy).field_71075_bZ.field_75098_d || enemy.func_70092_e(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c) > 1024.0) && !this.members.contains(enemy)) continue;
                invalidEnemies.add(enemy);
            }
            this.enemies.removeAll(invalidEnemies);
            if (this.fleeing && this.enemies.size() == 0) {
                this.fleeing = false;
                this.state = State.IDLE;
            }
            if (this.state == State.IDLE) {
                this.moveX = 0.0f;
                this.moveZ = 0.0f;
            } else {
                this.moveX += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.moveZ += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.normalizeMovement();
            }
            this.refreshMembers();
        }
    }

    private void splitHerd(DinosaurEntity entity) {
        this.members.remove(entity);
        Herd newHerd = new Herd(entity);
        newHerd.fleeing = this.fleeing;
        newHerd.state = this.state;
        newHerd.enemies = new HashSet<EntityLivingBase>(this.enemies);
        entity.herd = newHerd;
    }

    private void resetStateTicks() {
        this.stateTicks = this.random.nextInt(this.state == State.MOVING ? 2000 : 4000) + 1000;
        this.failedPathTicks = 0;
    }

    public void refreshMembers() {
        LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
        for (DinosaurEntity entity : this) {
            if (entity.isAlive() && !entity.getMetabolism().isStarving() && !entity.getMetabolism().isDehydrated()) continue;
            remove.add(entity);
        }
        this.members.removeAll(remove);
        if (this.leader.field_70173_aa > this.nextMemberCheck) {
            this.nextMemberCheck = this.leader.field_70173_aa + 20 + this.random.nextInt(20);
            AxisAlignedBB searchBounds = new AxisAlignedBB(this.center.field_72450_a - 16.0, this.center.field_72448_b - 5.0, this.center.field_72449_c - 16.0, this.center.field_72450_a + 16.0, this.center.field_72448_b + 5.0, this.center.field_72449_c + 16.0);
            LinkedList<Herd> otherHerds = new LinkedList<Herd>();
            for (DinosaurEntity entity : this.leader.field_70170_p.func_72872_a(this.leader.getClass(), searchBounds)) {
                if (entity.isCarcass() || entity.field_70128_L || entity.getMetabolism().isStarving() || entity.getMetabolism().isDehydrated()) continue;
                Herd otherHerd = entity.herd;
                if (otherHerd == null || otherHerd.members.size() == 1) {
                    if (this.size() >= this.herdType.getMetadata().getMaxHerdSize()) {
                        if (this.leader != null && GameRuleHandler.KILL_HERD_OUTCAST.getBoolean(this.leader.field_70170_p) && this.herdType.getMetadata().getDinosaurType() == Dinosaur.DinosaurType.AGGRESSIVE) {
                            this.enemies.add((EntityLivingBase)entity);
                        }
                        return;
                    }
                    this.addMember(entity);
                    continue;
                }
                if (otherHerd == this || otherHerds.contains(otherHerd)) continue;
                otherHerds.add(otherHerd);
            }
            for (Herd otherHerd : otherHerds) {
                int originalSize = this.size();
                if (otherHerd.size() <= originalSize && otherHerd.size() + originalSize < this.herdType.getMetadata().getMaxHerdSize()) {
                    for (DinosaurEntity member : otherHerd) {
                        this.members.add(member);
                        member.herd = this;
                    }
                    this.enemies.addAll(otherHerd.enemies);
                    this.fleeing |= otherHerd.fleeing;
                    otherHerd.disband();
                    continue;
                }
                if (originalSize + 1 <= this.herdType.getMetadata().getMaxHerdSize() || this.leader == null || !GameRuleHandler.KILL_HERD_OUTCAST.getBoolean(this.leader.field_70170_p) || this.herdType.getMetadata().getDinosaurType() != Dinosaur.DinosaurType.AGGRESSIVE) continue;
                for (DinosaurEntity entity : otherHerd) {
                    this.enemies.add((EntityLivingBase)entity);
                }
            }
        }
    }

    public void updateLeader() {
        this.leader = this.members.size() > 0 ? this.members.iterator().next() : null;
    }

    public Vec3d getCenterPosition() {
        if (this.members.size() == 1) {
            return this.leader.func_174791_d();
        }
        double x = 0.0;
        double z = 0.0;
        int count = 0;
        for (DinosaurEntity member : this.members) {
            if (member.isCarcass() || member.func_70090_H()) continue;
            x += member.field_70165_t;
            z += member.field_70161_v;
            ++count;
        }
        if (count <= 0) {
            return this.leader.func_174791_d();
        }
        return new Vec3d(x /= (double)count, (double)this.leader.field_70170_p.func_175645_m(new BlockPos(x, 0.0, z /= (double)count)).func_177956_o(), z);
    }

    public void addMember(DinosaurEntity entity) {
        Herd oldHerd = entity.herd;
        if (oldHerd != null) {
            oldHerd.members.remove(entity);
            this.enemies.addAll(oldHerd.enemies);
            this.fleeing |= oldHerd.fleeing;
            if (oldHerd.leader == entity) {
                oldHerd.updateLeader();
            }
        }
        entity.herd = this;
        this.members.add(entity);
    }

    public void disband() {
        this.leader = null;
        this.members.clear();
    }

    public int size() {
        return this.members.size();
    }

    @Override
    public Iterator<DinosaurEntity> iterator() {
        return this.members.iterator();
    }

    public void normalizeMovement() {
        float length = (float)Math.sqrt(Math.pow(this.moveX, 2.0) + Math.pow(this.moveZ, 2.0));
        this.moveX /= length;
        this.moveZ /= length;
    }

    public boolean shouldDefend(List<EntityLivingBase> entities) {
        return this.getScore(this) + this.herdType.getMetadata().getAttackBias() * (double)this.members.size() > this.getScore(entities);
    }

    public double getScore(Iterable<? extends EntityLivingBase> entities) {
        double score = 0.0;
        for (EntityLivingBase entityLivingBase : entities) {
            if (entityLivingBase == null || entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) continue;
            score += (double)entityLivingBase.func_110143_aJ() * entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        }
        return score;
    }

    public boolean isBusy() {
        return this.fleeing || this.state == State.MOVING || !this.enemies.isEmpty();
    }

    public static enum State {
        MOVING,
        IDLE;

    }
}

