/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;

public class Relationship {
    public static final int MAX_SCORE = 1000;
    private final UUID entity;
    private short score;

    public Relationship(UUID entity, short score) {
        this.entity = entity;
        this.score = score;
    }

    public static Relationship readFromNBT(NBTTagCompound compound) {
        UUID uuid = compound.func_186857_a("UUID");
        short score = compound.func_74765_d("Score");
        return new Relationship(uuid, score);
    }

    public boolean update(DinosaurEntity owner) {
        EntityLivingBase lastAttackerKiller;
        EntityLivingBase lastAttacker;
        DinosaurEntity entity = this.get(owner);
        if (entity == null) {
            return true;
        }
        boolean isPreoccupied = owner.func_70661_as().func_75500_f() && owner.func_70638_az() == null;
        double scaleScore = (double)this.score / 1000.0;
        Dinosaur.DinosaurType dinosaurType = owner.getDinosaur().getMetadata().getDinosaurType();
        if (this.score < 0) {
            if (!isPreoccupied && dinosaurType != Dinosaur.DinosaurType.SCARED && owner.func_70681_au().nextDouble() * scaleScore > 0.3) {
                owner.func_70624_b((EntityLivingBase)entity);
            }
        } else if (this.score > 0) {
            if ((dinosaurType == Dinosaur.DinosaurType.AGGRESSIVE || dinosaurType == Dinosaur.DinosaurType.NEUTRAL) && entity.func_70638_az() != null && owner.func_70681_au().nextDouble() * scaleScore > 0.3) {
                owner.func_70624_b(entity.func_70638_az());
            } else if (owner.family == null && !isPreoccupied && owner.func_70681_au().nextDouble() * scaleScore > 0.6) {
                owner.func_70661_as().func_75497_a((Entity)entity, 0.8);
            }
        }
        if ((lastAttacker = owner.func_70638_az()) != null && (lastAttacker.field_70128_L || lastAttacker instanceof DinosaurEntity && ((DinosaurEntity)lastAttacker).isCarcass()) && (lastAttackerKiller = lastAttacker.func_70643_av()) != null && lastAttackerKiller.func_110124_au().equals(this.entity)) {
            this.score = (short)(this.score + 100);
        }
        if (this.score > 1000) {
            this.score = (short)1000;
        } else if (this.score < -1000) {
            this.score = (short)-1000;
        }
        return entity == owner;
    }

    public DinosaurEntity get(DinosaurEntity owner) {
        for (Entity entity : owner.field_70170_p.field_72996_f) {
            if (!(entity instanceof DinosaurEntity) || !entity.func_110124_au().equals(this.entity)) continue;
            return (DinosaurEntity)entity;
        }
        return null;
    }

    public void updateHerd(DinosaurEntity owner) {
        DinosaurEntity entity;
        if (owner.family == null && (entity = this.get(owner)) != null) {
            double distance = entity.func_70068_e((Entity)owner);
            if (distance < 32.0) {
                this.score = (short)(this.score + 2);
            } else if (this.score > 0 && owner.func_70681_au().nextDouble() > 0.8) {
                this.score = (short)(this.score - 1);
            }
        }
    }

    public void onAttacked(double damage) {
        this.score = (short)((double)this.score - damage);
    }

    public void setFamily() {
        this.score = (short)1000;
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Relationship && ((Relationship)obj).entity.equals(this.entity);
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_186854_a("UUID", this.entity);
        compound.func_74777_a("Score", this.score);
    }

    public UUID getUUID() {
        return this.entity;
    }

    public short getScore() {
        return this.score;
    }
}

