/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import org.jurassicraft.server.config.JurassiCraftConfig;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.Herd;

public class SelectTargetEntityAI
extends EntityAIBase {
    protected final Sorter sorter;
    private final DinosaurEntity entity;
    private final Set<Class<? extends EntityLivingBase>> targetClasses;
    private EntityLivingBase targetEntity;

    public SelectTargetEntityAI(DinosaurEntity entity, Class<? extends EntityLivingBase>[] targetClasses) {
        this.entity = entity;
        this.targetClasses = new HashSet<Class<? extends EntityLivingBase>>();
        this.sorter = new Sorter((Entity)entity);
        Collections.addAll(this.targetClasses, targetClasses);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.resetAttackCooldown();
    }

    public void func_75249_e() {
        this.entity.func_70624_b(this.targetEntity);
        Herd herd = this.entity.herd;
        if (herd != null && this.targetEntity != null) {
            LinkedList<DinosaurEntity> enemies = new LinkedList<DinosaurEntity>();
            if (this.targetEntity instanceof DinosaurEntity && ((DinosaurEntity)this.targetEntity).herd != null) {
                enemies.addAll(((DinosaurEntity)this.targetEntity).herd.members);
            } else {
                enemies.add((DinosaurEntity)this.targetEntity);
            }
            for (EntityLivingBase entityLivingBase : enemies) {
                herd.enemies.add(entityLivingBase);
            }
        }
    }

    public boolean func_75250_a() {
        List entities;
        if (this.entity.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        if (!this.entity.getMetabolism().isHungry() && JurassiCraftConfig.ENTITIES.huntWhenHungry) {
            return false;
        }
        EntityLivingBase target = this.entity.func_70638_az();
        if (target != null && !target.field_70128_L && this.entity.func_70635_at().func_75522_a((Entity)target)) {
            return false;
        }
        if (!(this.entity.herd != null && this.entity.herd.fleeing || this.entity.getAgePercentage() <= 50 || this.entity.getOwner() != null && !this.entity.getMetabolism().isStarving() || this.entity.isSleeping() || this.entity.getAttackCooldown() > 0 || (entities = this.entity.field_70170_p.func_72872_a(EntityLivingBase.class, this.entity.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0))).size() <= 0)) {
            this.targetEntity = null;
            double bestScore = Double.MAX_VALUE;
            Collections.sort(entities, this.sorter);
            for (EntityLivingBase entity : entities) {
                double score;
                if (entity.equals((Object)this.entity) || entity.func_180799_ab() || !this.entity.func_70635_at().func_75522_a((Entity)entity) || !this.canAttack(entity)) continue;
                double d = score = entity.func_110143_aJ() <= 0.0f ? this.entity.func_70068_e((Entity)entity) / (double)entity.func_110143_aJ() : 0.0;
                if (entity.func_70090_H()) {
                    score *= 3.0;
                }
                if (!(score < bestScore)) continue;
                bestScore = score;
                if (entity.func_184187_bx() instanceof EntityLivingBase) {
                    this.targetEntity = (EntityLivingBase)entity.func_184187_bx();
                    continue;
                }
                this.targetEntity = entity;
            }
            return this.targetEntity != null;
        }
        return false;
    }

    private boolean canAttack(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!this.targetClasses.contains(entity.getClass())) {
            for (Class<? extends EntityLivingBase> clazz : this.targetClasses) {
                if (!clazz.isAssignableFrom(entity.getClass())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d1;
            double d0 = this.entity.func_70068_e(entity1);
            if (d0 < (d1 = this.entity.func_70068_e(entity2))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

