/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.metabolism;

import java.util.Random;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.util.AITickCounter;
import org.jurassicraft.server.entity.ai.util.AIUtils;

public class EntityAIFeeder
extends EntityAIBase {
    protected DinosaurEntity dinosaur;
    protected Path path;
    protected BlockPos feederPosition;
    protected AITickCounter tickCounter = new AITickCounter(40, 5);
    protected AITickCounter feederCooldownCounter = new AITickCounter(40, 10);

    public EntityAIFeeder(DinosaurEntity dinosaurIn) {
        this.dinosaur = dinosaurIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        this.tickCounter.increaseTick();
        if (this.tickCounter.shouldAIExecute() && this.dinosaur.getMetabolism().shouldUseFeeder() && !this.dinosaur.func_70610_aX()) {
            this.feederPosition = this.dinosaur.getClosestFeeder();
            if (this.feederPosition != null) {
                this.dinosaur.setIsFeederNearby(true);
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.feederPosition != null) {
            Random rand = new Random();
            BlockPos randomFeederPosition = new BlockPos(this.feederPosition.func_177958_n() + rand.nextInt(2), this.feederPosition.func_177956_o() + 1, this.feederPosition.func_177952_p() + rand.nextInt(2));
            this.path = this.dinosaur.func_70661_as().func_179680_a(randomFeederPosition);
        }
        if (!this.dinosaur.field_70170_p.field_72995_K && this.path != null) {
            TileEntity tile;
            this.dinosaur.func_70661_as().func_75484_a(this.path, 1.0);
            if (AIUtils.hasReachedBlockPos(this.dinosaur, this.feederPosition, this.dinosaur.getMetabolism().getContactDistance()) && (tile = this.dinosaur.field_70170_p.func_175625_s(this.feederPosition)) instanceof FeederBlockEntity) {
                FeederBlockEntity tileFeeder = (FeederBlockEntity)tile;
                this.feederCooldownCounter.increaseTick();
                if (tileFeeder.canFeedDinosaur(this.dinosaur) && this.feederCooldownCounter.shouldAIExecute()) {
                    tileFeeder.setOpen(true);
                    tileFeeder.setFeeding(this.dinosaur);
                    this.func_75251_c();
                    this.func_75253_b();
                }
            }
        }
    }

    public void func_75251_c() {
        this.path = null;
        this.feederPosition = null;
        this.dinosaur.func_70661_as().func_75499_g();
        this.dinosaur.setIsFeederNearby(false);
    }

    public boolean func_75253_b() {
        return this.dinosaur != null && this.path != null;
    }
}

