/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.navigation;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.jurassicraft.server.block.entity.ElectricFenceWireBlockEntity;
import org.jurassicraft.server.block.fence.ElectricFenceBaseBlock;
import org.jurassicraft.server.block.fence.ElectricFencePoleBlock;
import org.jurassicraft.server.block.fence.ElectricFenceWireBlock;
import org.jurassicraft.server.dinosaur.Dinosaur;

public class WalkNodeProcessorDinosaur
extends WalkNodeProcessor {
    private final Dinosaur dinosaur;

    public WalkNodeProcessorDinosaur(Dinosaur dinosaur) {
        this.dinosaur = dinosaur;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint southEast;
        PathPoint southWest;
        PathPoint northEast;
        PathPoint northWest;
        boolean canMoveWest;
        int optionIndex = 0;
        int stepHeight = 0;
        PathNodeType type = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(type) >= 0.0f) {
            stepHeight = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        int jumpHeight = this.dinosaur.getMetadata().getJumpHeight();
        if (!this.field_186326_b.func_70090_H() && !this.field_186326_b.func_180799_ab() && this.field_186326_b.field_70122_E && jumpHeight > 0 && jumpHeight > stepHeight) {
            stepHeight = jumpHeight + 1;
        }
        BlockPos ground = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double groundY = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)ground).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)ground).field_72337_e);
        PathPoint south = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, groundY, EnumFacing.SOUTH);
        PathPoint west = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, groundY, EnumFacing.WEST);
        PathPoint east = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, groundY, EnumFacing.EAST);
        PathPoint north = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, groundY, EnumFacing.NORTH);
        if (south != null && !south.field_75842_i && south.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = south;
        }
        if (west != null && !west.field_75842_i && west.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = west;
        }
        if (east != null && !east.field_75842_i && east.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = east;
        }
        if (north != null && !north.field_75842_i && north.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = north;
        }
        boolean canMoveNorth = north == null || north.field_186287_m == PathNodeType.OPEN || north.field_186286_l != 0.0f;
        boolean canMoveSouth = south == null || south.field_186287_m == PathNodeType.OPEN || south.field_186286_l != 0.0f;
        boolean canMoveEast = east == null || east.field_186287_m == PathNodeType.OPEN || east.field_186286_l != 0.0f;
        boolean bl = canMoveWest = west == null || west.field_186287_m == PathNodeType.OPEN || west.field_186286_l != 0.0f;
        if (canMoveNorth && canMoveWest && (northWest = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, groundY, EnumFacing.NORTH)) != null && !northWest.field_75842_i && northWest.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = northWest;
        }
        if (canMoveNorth && canMoveEast && (northEast = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, groundY, EnumFacing.NORTH)) != null && !northEast.field_75842_i && northEast.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = northEast;
        }
        if (canMoveSouth && canMoveWest && (southWest = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, groundY, EnumFacing.SOUTH)) != null && !southWest.field_75842_i && southWest.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = southWest;
        }
        if (canMoveSouth && canMoveEast && (southEast = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, groundY, EnumFacing.SOUTH)) != null && !southEast.field_75842_i && southEast.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionIndex++] = southEast;
        }
        return optionIndex;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int stepHeight, double currentGroundY, EnumFacing facing) {
        PathPoint point = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos ground = pos.func_177977_b();
        double groundY = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)ground).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)ground).field_72337_e);
        if (groundY - currentGroundY > (double)stepHeight + 0.125) {
            return null;
        }
        PathNodeType type = this.getPathNodeType(this.field_186326_b, x, y, z);
        float priority = this.field_186326_b.func_184643_a(type);
        double halfWidth = (double)this.field_186326_b.field_70130_N / 2.0;
        if (priority >= 0.0f) {
            point = this.func_176159_a(x, y, z);
            point.field_186287_m = type;
            point.field_186286_l = Math.max(point.field_186286_l, priority);
        }
        if (type == PathNodeType.WALKABLE) {
            return point;
        }
        if (point == null && stepHeight > 0 && type != PathNodeType.FENCE && type != PathNodeType.TRAPDOOR && (point = this.getSafePoint(x, y + 1, z, stepHeight - 1, currentGroundY, facing)) != null && (point.field_186287_m == PathNodeType.OPEN || point.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
            double pointX = (double)(x - facing.func_82601_c()) + 0.5;
            double pointZ = (double)(z - facing.func_82599_e()) + 0.5;
            AxisAlignedBB boundsAtPoint = new AxisAlignedBB(pointX - halfWidth, (double)y + 0.001, pointZ - halfWidth, pointX + halfWidth, (double)((float)y + this.field_186326_b.field_70131_O), pointZ + halfWidth);
            AxisAlignedBB pointBlockBounds = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
            AxisAlignedBB boundsAtGroundPoint = boundsAtPoint.func_72321_a(0.0, pointBlockBounds.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(boundsAtGroundPoint)) {
                point = null;
            }
        }
        if (type == PathNodeType.OPEN) {
            PathNodeType groundType;
            AxisAlignedBB boundsAtPoint = new AxisAlignedBB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + halfWidth + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(boundsAtPoint)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (groundType = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                point = this.func_176159_a(x, y, z);
                point.field_186287_m = PathNodeType.WALKABLE;
                point.field_186286_l = Math.max(point.field_186286_l, priority);
                return point;
            }
            int i = 0;
            while (y > 0 && type == PathNodeType.OPEN) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                type = this.getPathNodeType(this.field_186326_b, x, y, z);
                priority = this.field_186326_b.func_184643_a(type);
                if (type != PathNodeType.OPEN && priority >= 0.0f) {
                    point = this.func_176159_a(x, y, z);
                    point.field_186287_m = type;
                    point.field_186286_l = Math.max(point.field_186286_l, priority);
                    break;
                }
                if (!(priority < 0.0f)) continue;
                return null;
            }
        }
        return point;
    }

    public PathNodeType func_186330_a(IBlockAccess world, int x, int y, int z) {
        PathNodeType nodeType = this.func_189553_b(world, x, y, z);
        if (nodeType == PathNodeType.OPEN && y >= 1) {
            Block block = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType groundNodeType = this.func_189553_b(world, x, y - 1, z);
            PathNodeType pathNodeType = nodeType = groundNodeType != PathNodeType.WALKABLE && groundNodeType != PathNodeType.OPEN && groundNodeType != PathNodeType.WATER && groundNodeType != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (groundNodeType == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                nodeType = PathNodeType.DAMAGE_FIRE;
            }
            if (groundNodeType == PathNodeType.DAMAGE_CACTUS) {
                nodeType = PathNodeType.DAMAGE_CACTUS;
            }
        }
        BlockPos.PooledMutableBlockPos pool = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (nodeType == PathNodeType.WALKABLE) {
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    TileEntity entity;
                    if (offsetX == 0 && offsetZ == 0) continue;
                    IBlockState state = world.func_180495_p((BlockPos)pool.func_181079_c(x + offsetX, y, z + offsetZ));
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150434_aF || block instanceof ElectricFenceBaseBlock || block instanceof ElectricFencePoleBlock) {
                        nodeType = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block == Blocks.field_150480_ab) {
                        nodeType = PathNodeType.DANGER_FIRE;
                        continue;
                    }
                    if (!(block instanceof ElectricFenceWireBlock) || !((entity = world.func_175625_s((BlockPos)pool)) instanceof ElectricFenceWireBlockEntity) || !((ElectricFenceWireBlockEntity)entity).isPowered()) continue;
                    nodeType = PathNodeType.DAMAGE_CACTUS;
                }
            }
        }
        pool.func_185344_t();
        return nodeType;
    }

    private PathNodeType getPathNodeType(EntityLiving entity, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entity, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.field_176180_f, this.func_186323_c());
    }

    public PathNodeType func_189553_b(IBlockAccess access, int x, int y, int z) {
        TileEntity entity;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = access.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (material == Material.field_151579_a) {
            return PathNodeType.OPEN;
        }
        if (block == Blocks.field_150415_aT || block == Blocks.field_180400_cw || block == Blocks.field_150392_bi) {
            return PathNodeType.TRAPDOOR;
        }
        if (block == Blocks.field_150480_ab) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (block == Blocks.field_150434_aF || block instanceof ElectricFenceBaseBlock || block instanceof ElectricFencePoleBlock) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (block instanceof ElectricFenceWireBlock && (entity = access.func_175625_s(pos)) instanceof ElectricFenceWireBlockEntity && ((ElectricFenceWireBlockEntity)entity).isPowered()) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (block instanceof BlockDoor) {
            if (!((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return material == Material.field_151575_d ? PathNodeType.DOOR_WOOD_CLOSED : PathNodeType.DOOR_IRON_CLOSED;
            }
            return PathNodeType.DOOR_OPEN;
        }
        if (block instanceof BlockRailBase) {
            return PathNodeType.RAIL;
        }
        if (block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
            return PathNodeType.FENCE;
        }
        if (material.func_76224_d()) {
            return material == Material.field_151587_i ? PathNodeType.LAVA : PathNodeType.WATER;
        }
        return block.func_176205_b(access, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
    }
}

