/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.unused.aquatics;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.AdvancedSwimEntityAI;

public abstract class AIAquaticCreature
extends DinosaurEntity {
    public AIAquaticCreature(World world) {
        super(world);
        this.field_70765_h = new SwimmingMoveHelper();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AdvancedSwimEntityAI(this));
        this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shouldJumpOnLand() && !this.field_70171_ac && this.field_70122_E && this.field_70146_Z.nextDouble() < 0.01) {
            this.field_70181_x += (double)this.field_70131_O * 0.25;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N) * 0.25;
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N) * 0.25;
            this.field_70177_z = 45.0f - 90.0f * this.field_70146_Z.nextFloat();
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        if (this.field_70170_p.field_72995_K && this.func_70090_H()) {
            if (this.field_70159_w * this.field_70159_w > 0.01 || this.field_70179_y * this.field_70179_y > 0.01) {
                if (this.field_70146_Z.nextFloat() < 0.2f) {
                    Vec3d lookDirection = this.func_70676_i(0.0f);
                    for (int i = 0; i < 2; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - lookDirection.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - lookDirection.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - lookDirection.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            } else if (this.field_70146_Z.nextFloat() < 0.01f) {
                this.spawnBubbleParticles(3, this.field_70130_N, 0.9f * this.func_70047_e(), 0.5);
            }
        }
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(air--);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(this.getMaxAir());
        }
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.isInLiquid() && !this.isCarcass()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            this.field_70761_aq = this.field_70177_z;
            this.field_184618_aE = this.field_70721_aZ;
            double dPosX = this.field_70165_t - this.field_70169_q;
            double dPosZ = this.field_70161_v - this.field_70166_s;
            double dPosY = this.field_70163_u - this.field_70167_r;
            float dPos = MathHelper.func_76133_a((double)(dPosX * dPosX + dPosY * dPosY + dPosZ * dPosZ)) * 4.0f;
            if (dPos > 1.0f) {
                dPos = 1.0f;
            }
            this.field_70721_aZ += (dPos - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            this.field_70127_C = this.field_70125_A;
            this.field_70125_A -= 180.0f * (float)(dPosY / (double)dPos);
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151589_v);
    }

    protected boolean isInLiquid() {
        return this.func_70090_H() || this.func_180799_ab();
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int getMaxAir() {
        return 300;
    }

    protected boolean shouldJumpOnLand() {
        return true;
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final AIAquaticCreature swimmingEntity;

        public SwimmingMoveHelper() {
            super((EntityLiving)AIAquaticCreature.this);
            this.swimmingEntity = AIAquaticCreature.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.field_75648_a.func_70661_as().func_75500_f()) {
                double distanceX = this.field_75646_b - this.field_75648_a.field_70165_t;
                double distanceY = this.field_75647_c - this.field_75648_a.field_70163_u;
                double distanceZ = this.field_75644_d - this.field_75648_a.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distance = MathHelper.func_76133_a((double)distance);
                distanceY /= distance;
                float f = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 30.0f);
                if (this.field_75648_a.func_70090_H()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75648_a.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111126_e() * this.field_75645_e));
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * this.field_75645_e));
                }
                this.field_75648_a.field_70181_x += (double)this.field_75648_a.func_70689_ay() * distanceY * 0.1;
            } else {
                this.field_75648_a.func_70659_e(0.0f);
            }
        }
    }

    protected static class WaterMoveHelper
    extends EntityMoveHelper {
        public WaterMoveHelper(AIAquaticCreature animal) {
            super((EntityLiving)animal);
        }

        public void func_75641_c() {
            if (this.field_75648_a.func_70090_H()) {
                this.field_75648_a.field_70181_x += 0.005;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.field_75648_a.func_70661_as().func_75500_f()) {
                double dPosX = this.field_75646_b - this.field_75648_a.field_70165_t;
                double dPosY = this.field_75647_c - this.field_75648_a.field_70163_u;
                double dPosZ = this.field_75644_d - this.field_75648_a.field_70161_v;
                double dPos = dPosX * dPosX + dPosY * dPosY + dPosZ * dPosZ;
                if (dPos < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float dYaw = (float)(MathHelper.func_181159_b((double)dPosZ, (double)dPosX) * 57.2957763671875) - 90.0f;
                    this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, dYaw, 10.0f);
                    this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z;
                    float speed = 0.0f;
                    speed = this.field_75648_a.func_70090_H() ? (float)(this.field_75645_e * this.field_75648_a.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111126_e()) : (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    if (this.field_75648_a.func_70090_H()) {
                        this.field_75648_a.func_70659_e(speed * 0.02f);
                        float dPitch = -((float)(MathHelper.func_181159_b((double)dPosY, (double)MathHelper.func_76133_a((double)(dPosX * dPosX + dPosZ * dPosZ))) * 57.2957763671875));
                        dPitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)dPitch), (float)-85.0f, (float)85.0f);
                        this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, dPitch, 5.0f);
                        float motionFoward = MathHelper.func_76134_b((float)(this.field_75648_a.field_70125_A * ((float)Math.PI / 180)));
                        float motionVertical = MathHelper.func_76126_a((float)(this.field_75648_a.field_70125_A * ((float)Math.PI / 180)));
                        this.field_75648_a.field_191988_bg = motionFoward * speed;
                        this.field_75648_a.field_70701_bs = -motionVertical * speed;
                    } else {
                        this.field_75648_a.func_70659_e(speed * 0.1f);
                    }
                }
            } else {
                this.field_75648_a.func_70659_e(0.0f);
                this.field_75648_a.func_184646_p(0.0f);
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

