/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.unused.aquatics;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.unused.aquatics.AIAquaticCreature;

public class AIWanderAquatic
extends EntityAIBase {
    private final DinosaurEntity animal;
    private final SwimType swimType;
    private BlockPos target;
    private final int deepthInterval;
    private final int searchRange;
    private final int duration;
    private int timer;
    private final double distanceToTargetSq;
    private final double speed;
    private int attackTick;

    public AIWanderAquatic(AIAquaticCreature creature, double speed, double distanceToTargetSq, int duration, int searchRange, int deepthInterval) {
        this(creature, SwimType.NORMAL, speed, distanceToTargetSq, duration, searchRange, deepthInterval);
    }

    public AIWanderAquatic(AIAquaticCreature creature, SwimType swimType, double speed, double distanceToTargetSq, int duration, int searchRange, int deepthInterval) {
        this.animal = creature;
        this.deepthInterval = deepthInterval;
        this.searchRange = searchRange;
        this.distanceToTargetSq = distanceToTargetSq;
        this.duration = duration;
        this.timer = 0;
        this.speed = speed;
        this.swimType = swimType;
        this.func_75248_a(4);
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70090_H() || !this.animal.func_70661_as().func_75500_f()) {
            return false;
        }
        if (this.animal.func_70638_az() != null) {
            this.target = this.animal.func_70638_az().func_180425_c();
            return true;
        }
        BlockPos waterPos = this.findWaterTarget();
        if (waterPos != null) {
            this.target = waterPos;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.timer = this.duration + this.animal.func_70681_au().nextInt(this.duration);
    }

    public void func_75246_d() {
        BlockPos waterPos;
        if (this.animal.func_70638_az() != null) {
            this.target = this.animal.func_70638_az().func_180425_c();
        }
        double distanceX = (double)this.target.func_177958_n() - this.animal.field_70165_t;
        double distanceY = (double)this.target.func_177956_o() - this.animal.field_70163_u;
        double distanceZ = (double)this.target.func_177952_p() - this.animal.field_70161_v;
        double distanceSq = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
        double distance = Math.sqrt(distanceSq);
        this.animal.field_70159_w += distanceX / distance * 0.05 * this.animal.func_110148_a(EntityLiving.SWIM_SPEED).func_111126_e() * this.speed;
        this.animal.field_70181_x += distanceY / distance * 0.1 * this.animal.func_110148_a(EntityLiving.SWIM_SPEED).func_111126_e() * this.speed;
        this.animal.field_70179_y += distanceZ / distance * 0.05 * this.animal.func_110148_a(EntityLiving.SWIM_SPEED).func_111126_e() * this.speed;
        this.animal.field_70125_A += ((float)Math.atan2(this.animal.field_70181_x, Math.sqrt(this.animal.field_70159_w * this.animal.field_70159_w + this.animal.field_70179_y * this.animal.field_70179_y)) * 180.0f / (float)Math.PI - this.animal.field_70125_A) * 0.5f;
        this.animal.field_70761_aq += (-((float)Math.atan2(this.animal.field_70159_w, this.animal.field_70179_y)) * 180.0f / (float)Math.PI - this.animal.field_70761_aq) * 0.5f;
        this.animal.field_70177_z = this.animal.field_70761_aq;
        if (this.animal.func_70638_az() != null) {
            EntityLivingBase attackTarget = this.animal.func_70638_az();
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (distanceSq <= (double)(2.0f * (this.animal.field_70130_N + attackTarget.field_70130_N) * (this.animal.field_70130_N + attackTarget.field_70130_N)) && this.attackTick <= 0) {
                this.attackTick = 20;
                this.animal.func_70652_k((Entity)attackTarget);
            }
        } else if (distanceSq < this.distanceToTargetSq + (double)this.animal.field_70130_N) {
            BlockPos waterPos2 = this.findWaterTarget();
            if (waterPos2 != null) {
                this.target = waterPos2;
                this.timer = this.duration + this.animal.func_70681_au().nextInt(this.duration);
            }
        } else if (this.animal.field_70123_F && (waterPos = this.findWaterTarget()) != null) {
            this.target = waterPos;
            this.timer = this.duration + this.animal.func_70681_au().nextInt(this.duration);
        }
    }

    public boolean func_75253_b() {
        if (this.animal.func_70638_az() == null) {
            return this.timer-- > 0 && this.animal.func_70090_H();
        }
        return this.timer-- > 0 && this.animal.func_70638_az().func_70089_S() && this.animal.func_70090_H();
    }

    public void func_75251_c() {
        this.timer = 0;
        this.resetTarget();
    }

    public void setToAttackTarget(EntityLivingBase target) {
        BlockPos pos = new BlockPos(1.5 * this.animal.field_70165_t - target.field_70165_t, 1.5 * this.animal.field_70163_u - target.field_70163_u, 1.5 * this.animal.field_70161_v - target.field_70161_v);
        if (this.isWaterBlock(pos)) {
            this.target = pos;
        }
    }

    public void resetTarget() {
        this.target = this.animal.func_180425_c();
    }

    public boolean isWaterBlock(double posX, double posY, double posZ) {
        return this.isWaterBlock(new BlockPos(posX, posY, posZ));
    }

    public boolean isWaterBlock(BlockPos pos) {
        return this.animal.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockPos findWaterTarget() {
        Vec3d target = RandomPositionGenerator.func_75463_a((EntityCreature)this.animal, (int)this.searchRange, (int)this.deepthInterval);
        if (target == null) {
            return null;
        }
        if (this.swimType == SwimType.SURFACE) {
            BlockPos surfacePos = this.animal.getSurface((EntityLivingBase)this.animal);
            if (surfacePos == null) return null;
            target.func_72441_c(0.0, (double)((float)surfacePos.func_177956_o() - this.animal.field_70131_O - 1.0f), 0.0);
            return new BlockPos(target);
        } else if (this.swimType == SwimType.NEAR_SURFACE) {
            BlockPos surfacePos = this.animal.getSurface((EntityLivingBase)this.animal);
            if (surfacePos == null) return null;
            target.func_72441_c(0.0, (double)((float)surfacePos.func_177956_o() - this.animal.field_70131_O - 1.0f - (float)this.animal.func_70681_au().nextInt(this.deepthInterval)), 0.0);
            return new BlockPos(target);
        } else {
            if (this.swimType != SwimType.DEEP_WATER) return new BlockPos(target);
            BlockPos surfacePos = this.animal.getSurface((EntityLivingBase)this.animal);
            if (surfacePos == null) return null;
            BlockPos bottomPos = this.animal.getWaterBottom(surfacePos);
            if (bottomPos == null) return null;
            target.func_72441_c(0.0, (double)(bottomPos.func_177956_o() + this.animal.func_70681_au().nextInt(this.deepthInterval)), 0.0);
        }
        return new BlockPos(target);
    }

    public static enum SwimType {
        SURFACE,
        NEAR_SURFACE,
        NORMAL,
        DEEP_WATER;

    }
}

