/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.util;

import org.jurassicraft.server.entity.ai.util.AIUtils;

public class AITickCounter {
    private int tickCounter;
    private final int defaultExecutionFrequency;
    private int executionFrequency;
    private final int deadband;

    public AITickCounter(int defaultExecutionFrequency, int deadband) {
        this.defaultExecutionFrequency = defaultExecutionFrequency;
        this.deadband = deadband;
        this.executionFrequency = AIUtils.applyRandomDeadband(defaultExecutionFrequency, deadband);
    }

    public void increaseTick() {
        ++this.tickCounter;
    }

    public boolean shouldAIExecute() {
        if (this.tickCounter >= this.executionFrequency) {
            this.executionFrequency = AIUtils.applyRandomDeadband(this.defaultExecutionFrequency, this.deadband);
            this.tickCounter = 0;
            return true;
        }
        return false;
    }
}

