/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.util.RingXZTraverser;

public class AIUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();

    public static BlockPos findSurface(EntityLiving entity) {
        if (!entity.func_70090_H()) {
            return null;
        }
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        return AIUtils.findSurface(world, pos.func_177979_c(MathHelper.func_76141_d((float)(entity.field_70131_O / 2.0f))));
    }

    public static BlockPos findSurface(World world, BlockPos pos) {
        while (!world.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        return pos;
    }

    public static int getWaterDepth(EntityLiving entity, boolean fromEntity) {
        if (!entity.func_70090_H()) {
            return 0;
        }
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        int depth = 0;
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177984_a();
            ++depth;
        }
        pos = entity.func_180425_c().func_177977_b();
        if (fromEntity) {
            depth = 0;
        }
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177977_b();
            ++depth;
        }
        return depth + 1;
    }

    public static BlockPos getBottom(EntityLiving entity) {
        return new BlockPos(entity.field_70165_t, (double)AIUtils.getWaterDepth(entity, true), entity.field_70161_v);
    }

    public static BlockPos findShore(World world, BlockPos center) {
        for (int radius = 1; radius < 32; ++radius) {
            RingXZTraverser traverser = new RingXZTraverser(center, radius);
            for (BlockPos pos : traverser) {
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockLiquid) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean hasReachedPath(DinosaurEntity dinosaur, Path destination, float distanceWithin) {
        int zDistance;
        int yDistance;
        BlockPos dinosaurPos = dinosaur.func_180425_c();
        BlockPos destinationPos = new BlockPos(destination.func_75870_c().field_75839_a, destination.func_75870_c().field_75837_b, destination.func_75870_c().field_75838_c);
        int xDistance = dinosaurPos.func_177958_n() - destinationPos.func_177958_n();
        float distance = (float)Math.sqrt(xDistance * xDistance + (yDistance = dinosaurPos.func_177956_o() - destinationPos.func_177956_o()) * yDistance + (zDistance = dinosaurPos.func_177952_p() - destinationPos.func_177952_p()) * zDistance);
        return distance <= distanceWithin;
    }

    public static boolean hasReachedBlockPos(DinosaurEntity dinosaur, BlockPos destination, float distanceWithin) {
        int zDistance;
        int yDistance;
        BlockPos dinosaurPos = dinosaur.func_180425_c();
        int xDistance = dinosaurPos.func_177958_n() - destination.func_177958_n();
        float distance = (float)Math.sqrt(xDistance * xDistance + (yDistance = dinosaurPos.func_177956_o() - destination.func_177956_o()) * yDistance + (zDistance = dinosaurPos.func_177952_p() - destination.func_177952_p()) * zDistance);
        return distance <= distanceWithin;
    }

    public static int applyRandomDeadband(int value, int deadband) {
        int result = random.nextInt(deadband * 2 + 1) - deadband;
        return value + result;
    }
}

