/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.dinosaur;

import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GoatEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.ai.DilophosaurusSpitEntityAI;
import org.jurassicraft.server.entity.dinosaur.ChilesaurusEntity;
import org.jurassicraft.server.entity.dinosaur.CoelophysisEntity;
import org.jurassicraft.server.entity.dinosaur.CorythosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.CryolophosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.DeinonychusEntity;
import org.jurassicraft.server.entity.dinosaur.DryosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.GallimimusEntity;
import org.jurassicraft.server.entity.dinosaur.HerrerasaurusEntity;
import org.jurassicraft.server.entity.dinosaur.HuayangosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.HypsilophodonEntity;
import org.jurassicraft.server.entity.dinosaur.LeaellynasauraEntity;
import org.jurassicraft.server.entity.dinosaur.LesothosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.MicroceratusEntity;
import org.jurassicraft.server.entity.dinosaur.MonolophosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.MussaurusEntity;
import org.jurassicraft.server.entity.dinosaur.OrnithomimusEntity;
import org.jurassicraft.server.entity.dinosaur.PachycephalosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.ParasaurolophusEntity;
import org.jurassicraft.server.entity.dinosaur.ProceratosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.ProcompsognathusEntity;
import org.jurassicraft.server.entity.dinosaur.TitanisEntity;
import org.jurassicraft.server.entity.dinosaur.TriceratopsEntity;
import org.jurassicraft.server.entity.dinosaur.VelociraptorEntity;

public class DilophosaurusEntity
extends DinosaurEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> WATCHER_HAS_TARGET = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int targetCooldown;

    public DilophosaurusEntity(World world) {
        super(world);
        this.target(GoatEntity.class, EntityPlayer.class, EntityVillager.class, EntityAnimal.class, GallimimusEntity.class, ParasaurolophusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class, DeinonychusEntity.class, MussaurusEntity.class, ProcompsognathusEntity.class, DryosaurusEntity.class, HuayangosaurusEntity.class, CorythosaurusEntity.class, HerrerasaurusEntity.class, ProceratosaurusEntity.class, PachycephalosaurusEntity.class, DryosaurusEntity.class, LeaellynasauraEntity.class, TitanisEntity.class, CryolophosaurusEntity.class, OrnithomimusEntity.class, HypsilophodonEntity.class, CoelophysisEntity.class, MonolophosaurusEntity.class, ChilesaurusEntity.class, MicroceratusEntity.class, LesothosaurusEntity.class);
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_184812_l_()) {
            return;
        }
        VenomEntity venom = new VenomEntity(this.field_70170_p, this);
        double deltaX = target.field_70165_t - venom.field_70165_t;
        double deltaY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - venom.field_70163_u;
        double deltaZ = target.field_70161_v - venom.field_70161_v;
        float yOffset = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 0.2f;
        venom.func_70186_c(deltaX, deltaY + (double)yOffset, deltaZ, 1.5f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)venom);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new DilophosaurusSpitEntityAI(this, this.dinosaur.getMetadata().getAttackSpeed(), 40, 10.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_HAS_TARGET, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase target = this.func_70638_az();
            if (target != null && !target.field_70128_L && this.targetCooldown < 50) {
                this.targetCooldown = 50 + this.func_70681_au().nextInt(30);
            } else if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.field_70180_af.func_187227_b(WATCHER_HAS_TARGET, (Object)this.hasTarget());
        }
    }

    public boolean hasTarget() {
        if (!this.isCarcass() && !this.isSleeping()) {
            if (this.field_70170_p.field_72995_K) {
                return (Boolean)this.field_70180_af.func_187225_a(WATCHER_HAS_TARGET);
            }
            EntityLivingBase target = this.func_70638_az();
            return target != null && !target.field_70128_L || this.targetCooldown > 0;
        }
        return false;
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case CALLING: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.DILOPHOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.DILOPHOSAURUS_HURT;
            }
        }
        return null;
    }
}

