/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.genetics;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.util.LangUtils;

public class DinoDNA {
    private final int quality;
    private final String genetics;
    private final Dinosaur dinosaur;

    public DinoDNA(Dinosaur dinosaur, int quality, String genetics) {
        this.quality = quality;
        this.genetics = genetics;
        this.dinosaur = dinosaur;
    }

    public static DinoDNA fromStack(ItemStack stack) {
        return DinoDNA.readFromNBT(stack.func_77978_p());
    }

    public static DinoDNA readFromNBT(NBTTagCompound nbt) {
        return nbt == null ? null : new DinoDNA(EntityHandler.getDinosaurById(nbt.func_74762_e("Dinosaur")), nbt.func_74762_e("DNAQuality"), nbt.func_74779_i("Genetics"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DNAQuality", this.quality);
        nbt.func_74778_a("Genetics", this.genetics);
        nbt.func_74778_a("StorageId", "DinoDNA");
        nbt.func_74768_a("Dinosaur", EntityHandler.getDinosaurId(this.dinosaur));
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public String getGenetics() {
        return this.genetics;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(TextFormatting.DARK_AQUA + LangUtils.translate(LangUtils.LORE.get("dinosaur"), new Object[0]).replace("{dino}", LangUtils.getDinoName(this.dinosaur)));
        TextFormatting colour = this.quality > 75 ? TextFormatting.GREEN : (this.quality > 50 ? TextFormatting.YELLOW : (this.quality > 25 ? TextFormatting.GOLD : (this.quality == -1 ? TextFormatting.AQUA : TextFormatting.RED)));
        tooltip.add(colour + LangUtils.translate(LangUtils.LORE.get("dna_quality"), new Object[0]).replace("{quality}", LangUtils.getFormattedQuality(this.quality)));
        tooltip.add(TextFormatting.BLUE + LangUtils.translate(LangUtils.LORE.get("genetic_code"), new Object[0]).replace("{code}", LangUtils.getFormattedGenetics(this.genetics)));
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public int getMetadata() {
        return EntityHandler.getDinosaurId(this.dinosaur);
    }
}

