/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.ExtractableItem;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangUtils;

public class DinosaurMeatItem
extends ItemFood
implements ExtractableItem {
    public DinosaurMeatItem() {
        super(3, 0.3f, true);
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.FOODS);
    }

    public static Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77952_i());
    }

    public String func_77653_i(ItemStack stack) {
        return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{dino}", LangUtils.getDinoName(DinosaurMeatItem.getDinosaur(stack)));
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            DinosaurMeatItem.getDinosaur(stack).applyMeatEffect(player, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> lore, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Genetics") && nbt.func_74764_b("DNAQuality")) {
            int quality = nbt.func_74762_e("DNAQuality");
            TextFormatting colour = quality > 75 ? TextFormatting.GREEN : (quality > 50 ? TextFormatting.YELLOW : (quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
            lore.add(colour + LangUtils.translate(LangUtils.LORE.get("dna_quality"), new Object[0]).replace("{quality}", LangUtils.getFormattedQuality(quality)));
            lore.add(TextFormatting.BLUE + LangUtils.translate(LangUtils.LORE.get("genetic_code"), new Object[0]).replace("{code}", LangUtils.getFormattedGenetics(nbt.func_74779_i("Genetics"))));
        }
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        List list = this.getItemSubtypes((Item)this);
        return list;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        return null;
    }

    @Override
    public ItemStack getExtractOutput(ItemStack stack, Random random) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            DinoDNA dna = new DinoDNA(EntityHandler.getDinosaurById(stack.func_77952_i()), -1, "");
            dna.writeToNBT(nbt);
        } else if (!nbt.func_74764_b("Dinosaur")) {
            nbt.func_74768_a("Dinosaur", stack.func_77952_i());
        }
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
        output.func_77982_d(nbt);
        return output;
    }
}

