/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.DisplayBlock;
import org.jurassicraft.server.block.entity.DisplayBlockEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangUtils;

public class DisplayBlockItem
extends Item {
    public DisplayBlockItem() {
        this.func_77637_a(TabHandler.DECORATIONS);
        this.func_77627_a(true);
    }

    private static Boolean getGender(World world, ItemStack stack) {
        Boolean type = null;
        if (world != null) {
            byte mode = DisplayBlockItem.getGenderType(stack);
            type = mode > 0 ? Boolean.valueOf(mode == 1) : null;
        }
        return type;
    }

    public static Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(DisplayBlockItem.getDinosaurID(stack));
    }

    public static int getMetadata(int dinosaur, boolean isFossilized, boolean isSkeleton) {
        return dinosaur << 2 | (isFossilized ? 1 : 0) << 1 | (isSkeleton ? 1 : 0);
    }

    public static int getDinosaurID(ItemStack stack) {
        return stack.func_77960_j() >> 2;
    }

    public static boolean isFossilized(ItemStack stack) {
        return (stack.func_77960_j() >> 1 & 1) == 1;
    }

    public static boolean isSkeleton(ItemStack stack) {
        return (stack.func_77960_j() & 1) == 1;
    }

    public static byte getGenderType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Gender")) {
            return stack.func_77978_p().func_74771_c("Gender");
        }
        return 0;
    }

    public static byte getSkeletonType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Type")) {
            return stack.func_77978_p().func_74771_c("Type");
        }
        return 0;
    }

    public static void setGenderType(ItemStack stack, byte type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74774_a("Gender", type);
    }

    public static void setSkeletonType(ItemStack stack, byte type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74774_a("Type", type);
    }

    public static int changeMode(ItemStack stack) {
        int mode = DisplayBlockItem.getGenderType(stack) + 1;
        DisplayBlockItem.setGenderType(stack, (byte)(mode %= 3));
        return mode;
    }

    public static int changeSkeletonVariant(ItemStack stack) {
        int dinosaur = DisplayBlockItem.getDinosaurID(stack);
        int newVariant = DisplayBlockItem.getSkeletonType(stack) + 1;
        if ((newVariant %= 16) >= EntityHandler.getDinosaurById(dinosaur).getMetadata().skeletonPoses().length) {
            newVariant = 0;
        }
        DisplayBlockItem.setSkeletonType(stack, (byte)newVariant);
        return newVariant;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(side);
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && !player.func_70093_af()) {
            DisplayBlock block = BlockHandler.DISPLAY_BLOCK;
            if (block.func_176196_c(world, pos)) {
                IBlockState state = block.func_176223_P();
                world.func_175656_a(pos, block.func_180642_a(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player));
                block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                byte mode = DisplayBlockItem.getGenderType(stack);
                world.func_184133_a(null, pos, SoundType.field_185848_a.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185848_a.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185848_a.func_185847_b() * 0.8f);
                DisplayBlockEntity tile = (DisplayBlockEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setDinosaur(DisplayBlockItem.getDinosaurID(stack), mode > 0 ? mode == 1 : world.field_73012_v.nextBoolean(), DisplayBlockItem.isSkeleton(stack), DisplayBlockItem.isFossilized(stack), DisplayBlockItem.getSkeletonType(stack));
                    tile.setRot(180 - (int)player.func_70079_am());
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
            }
        } else if (player.func_70093_af()) {
            int mode = DisplayBlockItem.changeMode(stack);
            if (world.field_72995_K) {
                TextComponentString change = new TextComponentString(LangUtils.translate(LangUtils.GENDER_CHANGE.get("actionfigure"), new Object[0]).replace("{mode}", LangUtils.getGenderMode(mode)));
                change.func_150256_b().func_150238_a(TextFormatting.GOLD);
                ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public String func_77653_i(ItemStack stack) {
        String dinoName = LangUtils.getDinoName(DisplayBlockItem.getDinosaur(stack));
        if (!DisplayBlockItem.isSkeleton(stack)) {
            return LangUtils.translate("item.action_figure.name", new Object[0]).replace("{dino}", dinoName);
        }
        return LangUtils.translate("item.skeleton." + (DisplayBlockItem.isFossilized(stack) ? "fossil" : "fresh") + ".name", new Object[0]).replace("{dino}", dinoName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), false, false)));
                subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), true, true)));
                subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), false, true)));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lore, ITooltipFlag tooltipFlag) {
        Boolean type = DisplayBlockItem.getGender(world, stack);
        lore.add(TextFormatting.GOLD + LangUtils.translate("gender.name", new Object[0]) + ": " + LangUtils.getGenderMode(type != null ? (type.booleanValue() ? 1 : 2) : 0));
        lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_gender.name", new Object[0]));
        Dinosaur dinosaur = EntityHandler.getDinosaurById(DisplayBlockItem.getDinosaurID(stack));
        if (DisplayBlockItem.isSkeleton(stack) && dinosaur.getMetadata().skeletonPoses().length > 1) {
            lore.add(TextFormatting.YELLOW + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getSkeletonMode(dinosaur, DisplayBlockItem.getSkeletonType(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (DisplayBlockItem.isSkeleton(stack) && player.func_70093_af()) {
            byte oldVariant = DisplayBlockItem.getSkeletonType(stack);
            int variant = DisplayBlockItem.changeSkeletonVariant(stack);
            if (variant != oldVariant && world.field_72995_K) {
                TextComponentString change = new TextComponentString(LangUtils.translate(LangUtils.SKELETON_CHANGE.get("variant"), new Object[0]).replace("{mode}", LangUtils.getSkeletonMode(EntityHandler.getDinosaurById(DisplayBlockItem.getDinosaurID(stack)), variant)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

