/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.block.NestFossilBlock;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;

public class FossilizedEggItem
extends Item
implements GrindableItem {
    public FossilizedEggItem() {
        this.func_77637_a(TabHandler.FOSSILS);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (NestFossilBlock.Variant variant : NestFossilBlock.Variant.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, variant.ordinal()));
            }
        }
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(3);
        if (outputType == 0) {
            List<Dinosaur> dinosaurs = EntityHandler.getPrehistoricDinosaurs();
            ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, EntityHandler.getDinosaurId(dinosaurs.get(random.nextInt(dinosaurs.size()))));
            output.func_77982_d(tag);
            return output;
        }
        if (outputType == 1) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        NBTTagCompound tag = inputItem.func_77978_p();
        List<Dinosaur> dinosaurs = EntityHandler.getPrehistoricDinosaurs();
        float single = 33.333332f;
        float dinoSingle = single / (float)dinosaurs.size();
        for (Dinosaur dinosaur : dinosaurs) {
            ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, EntityHandler.getDinosaurId(dinosaur));
            output.func_77982_d(tag);
            list.add(Pair.of((Object)Float.valueOf(dinoSingle), (Object)output));
        }
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151100_aR, 1, 15)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151145_ak)));
        return list;
    }
}

