/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.SwarmBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.config.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.AmberItem;
import org.jurassicraft.server.item.AncientRecordItem;
import org.jurassicraft.server.item.AttractionSignItem;
import org.jurassicraft.server.item.BasicFoodItem;
import org.jurassicraft.server.item.BasicItem;
import org.jurassicraft.server.item.BugItem;
import org.jurassicraft.server.item.DNAItem;
import org.jurassicraft.server.item.Dart;
import org.jurassicraft.server.item.DartGun;
import org.jurassicraft.server.item.DinoScannerItem;
import org.jurassicraft.server.item.DinosaurEggItem;
import org.jurassicraft.server.item.DinosaurMeatItem;
import org.jurassicraft.server.item.DinosaurSpawnEggItem;
import org.jurassicraft.server.item.DinosaurSteakItem;
import org.jurassicraft.server.item.DisplayBlockItem;
import org.jurassicraft.server.item.EmptySyringeItem;
import org.jurassicraft.server.item.EntityRightClickItem;
import org.jurassicraft.server.item.FieldGuideItem;
import org.jurassicraft.server.item.FineNetItem;
import org.jurassicraft.server.item.FossilItem;
import org.jurassicraft.server.item.FossilizedEggItem;
import org.jurassicraft.server.item.GracilariaItem;
import org.jurassicraft.server.item.HatchedEggItem;
import org.jurassicraft.server.item.JournalItem;
import org.jurassicraft.server.item.MuralItem;
import org.jurassicraft.server.item.PaddockSignItem;
import org.jurassicraft.server.item.PlantCallusItem;
import org.jurassicraft.server.item.PlantDNAItem;
import org.jurassicraft.server.item.PlantFossilItem;
import org.jurassicraft.server.item.PlantSoftTissueItem;
import org.jurassicraft.server.item.PlasterAndBandageItem;
import org.jurassicraft.server.item.PotionDart;
import org.jurassicraft.server.item.RhamnusBerriesItem;
import org.jurassicraft.server.item.SaplingSeedItem;
import org.jurassicraft.server.item.SeededFruitItem;
import org.jurassicraft.server.item.SoftTissueItem;
import org.jurassicraft.server.item.StorageDiscItem;
import org.jurassicraft.server.item.SwarmItem;
import org.jurassicraft.server.item.SyringeItem;
import org.jurassicraft.server.item.TwigFossilItem;
import org.jurassicraft.server.item.VehicleItem;
import org.jurassicraft.server.item.WestIndianLilacBerriesItem;
import org.jurassicraft.server.item.block.AncientDoorItem;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.RegistryHandler;

public class ItemHandler {
    public static final Map<TreeType, AncientDoorItem> ANCIENT_DOORS = new HashMap<TreeType, AncientDoorItem>();
    public static final PlasterAndBandageItem PLASTER_AND_BANDAGE = new PlasterAndBandageItem();
    public static final DinosaurSpawnEggItem SPAWN_EGG = new DinosaurSpawnEggItem();
    public static final DNAItem DNA = new DNAItem();
    public static final DinosaurEggItem EGG = new DinosaurEggItem();
    public static final HatchedEggItem HATCHED_EGG = new HatchedEggItem();
    public static final SoftTissueItem SOFT_TISSUE = new SoftTissueItem();
    public static final PlantSoftTissueItem PLANT_SOFT_TISSUE = new PlantSoftTissueItem();
    public static final DinosaurMeatItem DINOSAUR_MEAT = new DinosaurMeatItem();
    public static final DinosaurSteakItem DINOSAUR_STEAK = new DinosaurSteakItem();
    public static final PaddockSignItem PADDOCK_SIGN = new PaddockSignItem();
    public static final AttractionSignItem ATTRACTION_SIGN = new AttractionSignItem();
    public static final AmberItem AMBER = new AmberItem();
    public static final BasicItem PETRI_DISH = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem PETRI_DISH_AGAR = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem EMPTY_TEST_TUBE = new BasicItem(TabHandler.ITEMS);
    public static final SyringeItem SYRINGE = new SyringeItem();
    public static final EmptySyringeItem EMPTY_SYRINGE = new EmptySyringeItem();
    public static final StorageDiscItem STORAGE_DISC = new StorageDiscItem();
    public static final BasicItem DNA_NUCLEOTIDES = new BasicItem(TabHandler.ITEMS);
    public static final PlantDNAItem PLANT_DNA = new PlantDNAItem();
    public static final BasicItem SEA_LAMPREY = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem IRON_BLADES = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem IRON_ROD = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem DISC_DRIVE = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem LASER = new BasicItem(TabHandler.ITEMS);
    public static final Item GROWTH_SERUM = new EntityRightClickItem((Function<EntityRightClickItem.Interaction, Boolean>)((Function)interaction -> {
        if (interaction.getTarget() instanceof DinosaurEntity) {
            if (!JurassiCraftConfig.ITEMS.disableGrowthSerum) {
                DinosaurEntity dinosaur = (DinosaurEntity)interaction.getTarget();
                if (!dinosaur.isCarcass()) {
                    dinosaur.setFullyGrown();
                    interaction.getStack().func_190918_g(1);
                    if (!interaction.getPlayer().field_71075_bZ.field_75098_d) {
                        interaction.getPlayer().field_71071_by.func_70441_a(new ItemStack((Item)EMPTY_SYRINGE));
                    }
                    return true;
                }
            } else {
                if (!interaction.getTarget().field_70170_p.field_72995_K) {
                    EntityPlayerMP player = (EntityPlayerMP)interaction.getPlayer();
                    TextComponentTranslation growthTranslation = new TextComponentTranslation("item.growth_serum.denied", new Object[0]);
                    growthTranslation.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)growthTranslation, ChatType.GAME_INFO));
                }
                return false;
            }
        }
        return false;
    })).func_77637_a(TabHandler.ITEMS);
    public static final Item BREEDING_WAND = new EntityRightClickItem((Function<EntityRightClickItem.Interaction, Boolean>)((Function)interaction -> {
        ItemStack stack = interaction.getPlayer().func_184586_b(interaction.getHand());
        NBTTagCompound nbt = stack.func_190925_c("wand_info");
        if (nbt.func_150297_b("dino_id", 99)) {
            Entity entity = interaction.getPlayer().field_70170_p.func_73045_a(nbt.func_74762_e("dino_id"));
            if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isMale() != ((DinosaurEntity)interaction.getTarget()).isMale()) {
                ((DinosaurEntity)entity).breed((DinosaurEntity)interaction.getTarget());
                ((DinosaurEntity)interaction.getTarget()).breed((DinosaurEntity)entity);
            } else if (entity != interaction.getTarget()) {
                nbt.func_82580_o("dino_id");
            }
            return true;
        }
        if (interaction.getTarget() instanceof DinosaurEntity) {
            nbt.func_74768_a("dino_id", interaction.getTarget().func_145782_y());
            return true;
        }
        return false;
    })).func_77637_a(TabHandler.ITEMS);
    public static final Item BIRTHING_WAND = new EntityRightClickItem((Function<EntityRightClickItem.Interaction, Boolean>)((Function)interaction -> {
        if (interaction.getTarget() instanceof DinosaurEntity) {
            ((DinosaurEntity)interaction.getTarget()).giveBirth();
            return true;
        }
        return false;
    }));
    public static final Item PREGNANCY_TEST = new EntityRightClickItem((Function<EntityRightClickItem.Interaction, Boolean>)((Function)interaction -> {
        if (interaction.getTarget() instanceof DinosaurEntity && !interaction.getPlayer().field_70170_p.field_72995_K) {
            DinosaurEntity dino = (DinosaurEntity)interaction.getTarget();
            interaction.getPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("dinosaur.pregnancytest." + (dino.isMale() ? "male" : (dino.isPregnant() ? "pregnant" : "not_pregnant")), new Object[0]), false);
            return true;
        }
        return false;
    }));
    public static final BasicItem PLANT_CELLS = new BasicItem(TabHandler.ITEMS);
    public static final PlantCallusItem PLANT_CALLUS = new PlantCallusItem();
    public static final BasicItem PLANT_CELLS_PETRI_DISH = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem TRACKER = new BasicItem(TabHandler.ITEMS);
    public static final AncientRecordItem JURASSICRAFT_THEME_DISC = new AncientRecordItem("jurassicraft_theme", SoundHandler.JURASSICRAFT_THEME);
    public static final AncientRecordItem TROODONS_AND_RAPTORS_DISC = new AncientRecordItem("troodons_and_raptors", SoundHandler.TROODONS_AND_RAPTORS);
    public static final AncientRecordItem DONT_MOVE_A_MUSCLE_DISC = new AncientRecordItem("dont_move_a_muscle", SoundHandler.DONT_MOVE_A_MUSCLE);
    public static final DisplayBlockItem DISPLAY_BLOCK_ITEM = new DisplayBlockItem();
    public static final BasicItem AMBER_KEYCHAIN = new BasicItem(TabHandler.DECORATIONS);
    public static final BasicItem AMBER_CANE = new BasicItem(TabHandler.DECORATIONS);
    public static final BasicItem MR_DNA_KEYCHAIN = new BasicItem(TabHandler.DECORATIONS);
    public static final BasicItem BASIC_CIRCUIT = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem ADVANCED_CIRCUIT = new BasicItem(TabHandler.ITEMS);
    public static final Item AJUGINUCULA_SMITHII_SEEDS = new ItemSeeds((Block)BlockHandler.AJUGINUCULA_SMITHII, Blocks.field_150458_ak).func_77655_b("ajuginucula_smithii_seeds").func_77637_a(TabHandler.PLANTS);
    public static final Item AJUGINUCULA_SMITHII_LEAVES = new ItemFood(1, 0.5f, false).func_77655_b("ajuginucula_smithii_leaves").func_77637_a(TabHandler.PLANTS);
    public static final BasicItem AJUGINUCULA_SMITHII_OIL = new BasicItem(TabHandler.PLANTS);
    public static final Item WILD_ONION = new ItemSeedFood(3, 0.3f, (Block)BlockHandler.WILD_ONION, Blocks.field_150458_ak).func_77655_b("wild_onion").func_77637_a(TabHandler.PLANTS);
    public static final Item WILD_POTATO_SEEDS = new ItemSeeds((Block)BlockHandler.WILD_POTATO_PLANT, Blocks.field_150458_ak).func_77637_a(TabHandler.PLANTS);
    public static final Item RHAMNUS_SEEDS = new ItemSeeds((Block)BlockHandler.RHAMNUS_SALICIFOLIUS_PLANT, Blocks.field_150458_ak).func_77637_a(TabHandler.PLANTS);
    public static final Item WILD_POTATO = new ItemFood(1, 0.1f, false).func_77637_a((CreativeTabs)TabHandler.FOODS);
    public static final Item WILD_POTATO_COOKED = new ItemFood(6, 0.6f, false).func_77637_a((CreativeTabs)TabHandler.FOODS);
    public static final Item RHAMNUS_BERRIES = new RhamnusBerriesItem(3, 0.3f).func_77637_a(TabHandler.FOODS);
    public static final Item WEST_INDIAN_LILAC_BERRIES = new WestIndianLilacBerriesItem().func_77637_a(TabHandler.FOODS);
    public static final GracilariaItem GRACILARIA = (GracilariaItem)new GracilariaItem((Block)BlockHandler.GRACILARIA).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem AULOPORA = (GracilariaItem)new GracilariaItem((Block)BlockHandler.AULOPORA).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem CLADOCHONUS = (GracilariaItem)new GracilariaItem((Block)BlockHandler.CLADOCHONUS).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem ENALLHELIA = (GracilariaItem)new GracilariaItem((Block)BlockHandler.ENALLHELIA).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem MICROSOLENA = (GracilariaItem)new GracilariaItem((Block)BlockHandler.MICROSOLENA).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem HIPPURITES_RADIOSUS = (GracilariaItem)new GracilariaItem((Block)BlockHandler.HIPPURITES_RADIOSUS).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem LITHOSTROTION = (GracilariaItem)new GracilariaItem((Block)BlockHandler.LITHOSTROTION).func_77637_a(TabHandler.PLANTS);
    public static final GracilariaItem STYLOPHYLLOPSIS = (GracilariaItem)new GracilariaItem((Block)BlockHandler.STYLOPHYLLOPSIS).func_77637_a(TabHandler.PLANTS);
    public static final BasicItem LIQUID_AGAR = new BasicItem(TabHandler.PLANTS);
    public static final DinoScannerItem DINO_SCANNER = new DinoScannerItem();
    public static final PlantFossilItem PLANT_FOSSIL = new PlantFossilItem();
    public static final TwigFossilItem TWIG_FOSSIL = new TwigFossilItem();
    public static final Map<String, FossilItem> FOSSILS = new HashMap<String, FossilItem>();
    public static final Map<String, FossilItem> FRESH_FOSSILS = new HashMap<String, FossilItem>();
    public static final FossilItem FOSSIL_DUMMY = new FossilItem("dummy", false);
    public static final FossilizedEggItem FOSSILIZED_EGG = new FossilizedEggItem();
    public static final BasicItem GYPSUM_POWDER = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem COMPUTER_SCREEN = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem KEYBOARD = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem DNA_ANALYZER = new BasicItem(TabHandler.ITEMS);
    public static final BasicFoodItem CHILEAN_SEA_BASS = new BasicFoodItem(10, 1.0f, false, TabHandler.FOODS);
    public static final BasicFoodItem FUN_FRIES = new BasicFoodItem(4, 2.0f, false, TabHandler.FOODS);
    public static final BasicFoodItem OILED_POTATO_STRIPS = new BasicFoodItem(1, 0.0f, false, TabHandler.FOODS);
    public static final FieldGuideItem PALEO_PAD = new FieldGuideItem();
    public static final BasicItem LUNCH_BOX = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem STAMP_SET = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem CAR_CHASSIS = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem ENGINE_SYSTEM = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem CAR_SEATS = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem CAR_TIRE = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem CAR_WINDSCREEN = new BasicItem(TabHandler.ITEMS);
    public static final BasicItem UNFINISHED_CAR = new BasicItem(TabHandler.ITEMS);
    public static final JournalItem INGEN_JOURNAL = new JournalItem();
    public static final VehicleItem VEHICLE_ITEM = new VehicleItem();
    public static final MuralItem MURAL = new MuralItem();
    public static final SaplingSeedItem PHOENIX_SEEDS = new SaplingSeedItem((Block)BlockHandler.ANCIENT_SAPLINGS.get((Object)TreeType.PHOENIX));
    public static final SeededFruitItem PHOENIX_FRUIT = (SeededFruitItem)new SeededFruitItem(PHOENIX_SEEDS, 4, 0.4f).func_77637_a(TabHandler.FOODS);
    public static final BugItem CRICKETS = new BugItem(stack -> {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (item == Items.field_151014_N) {
            return 1;
        }
        if (block == Blocks.field_150329_H) {
            return 2;
        }
        if (item == Items.field_151015_O) {
            return 3;
        }
        if (block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
            return 7;
        }
        if (block == Blocks.field_150407_cf) {
            return 27;
        }
        return 0;
    });
    public static final BugItem COCKROACHES = new BugItem(stack -> {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (item == Items.field_151014_N || item == Items.field_151081_bc) {
            return 1;
        }
        if (item == Items.field_151015_O || item == Items.field_151080_bb) {
            return 2;
        }
        if (item == Items.field_151127_ba || item == Items.field_151174_bG) {
            return 3;
        }
        if (item == Items.field_151172_bF) {
            return 4;
        }
        if (item == Items.field_151025_P || item == Items.field_151115_aP) {
            return 6;
        }
        if (item == Items.field_151076_bf || item == Items.field_151077_bg) {
            return 7;
        }
        if (item == Items.field_151147_al || item == Items.field_151157_am) {
            return 8;
        }
        if (item == Items.field_151082_bd || item == Items.field_151083_be) {
            return 10;
        }
        if (item == DINOSAUR_MEAT || item == DINOSAUR_STEAK) {
            return 12;
        }
        if (block == Blocks.field_150407_cf || block == Blocks.field_150423_aK) {
            return 16;
        }
        if (block == Blocks.field_150440_ba) {
            return 27;
        }
        return 0;
    });
    public static final BugItem MEALWORM_BEETLES = new BugItem(stack -> {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (item == Items.field_151014_N || item == Items.field_151081_bc) {
            return 1;
        }
        if (item == Items.field_151080_bb || item == Items.field_151015_O) {
            return 2;
        }
        if (item == Items.field_151174_bG) {
            return 3;
        }
        if (block == Blocks.field_150459_bM) {
            return 4;
        }
        if (item == Items.field_151025_P) {
            return 6;
        }
        if (block == Blocks.field_150407_cf) {
            return 16;
        }
        return 0;
    });
    public static final FineNetItem FINE_NET = new FineNetItem();
    public static final SwarmItem PLANKTON = new SwarmItem(() -> ((SwarmBlock)BlockHandler.PLANKTON_SWARM).func_176223_P());
    public static final SwarmItem KRILL = new SwarmItem(() -> ((SwarmBlock)BlockHandler.KRILL_SWARM).func_176223_P());
    public static final BasicFoodItem GOAT_RAW = new BasicFoodItem(3, 0.3f, true, TabHandler.FOODS);
    public static final BasicFoodItem GOAT_COOKED = new BasicFoodItem(6, 1.0f, true, TabHandler.FOODS);
    public static final DartGun DART_GUN = new DartGun();
    public static final Dart DART = new Dart((entity, stack) -> entity.func_70097_a(DamageSource.field_76377_j, 1.0f), 0xFFFFFF, "");
    public static final Dart DART_TRANQUILIZER = new Dart((entity, stack) -> entity.tranquilize(600), 3708371, "Tranquilzer Dinosaurs for 20 seconds");
    public static final Dart DART_EUTHANIZATION = new Dart((entity, stack) -> entity.setDeathIn(200), 0, "Euthanizes Dinosaurs after 10 seconds");
    public static final Dart DART_TIPPED_POTION = new PotionDart();

    public static void init() {
        ItemHandler.registerItem(FOSSILIZED_EGG, "Fossilized Egg");
        for (Dinosaur dinosaur : EntityHandler.getDinosaurs().values()) {
            String[] boneTypes;
            for (String boneType : boneTypes = dinosaur.getMetadata().getBones()) {
                FossilItem fossil;
                if (!(dinosaur instanceof Hybrid) && !FOSSILS.containsKey(boneType)) {
                    fossil = new FossilItem(boneType, false);
                    FOSSILS.put(boneType, fossil);
                    ItemHandler.registerItem(fossil, boneType);
                }
                if (FRESH_FOSSILS.containsKey(boneType)) continue;
                fossil = new FossilItem(boneType, true);
                FRESH_FOSSILS.put(boneType, fossil);
                ItemHandler.registerItem(fossil, boneType + " Fresh");
            }
        }
        ItemHandler.registerItem(SPAWN_EGG, "Dino Spawn Egg");
        ItemHandler.registerItem(PALEO_PAD, "Paleo Pad");
        ItemHandler.registerItem(AMBER, "Amber");
        ItemHandler.registerItem(SEA_LAMPREY, "Sea Lamprey");
        ItemHandler.registerItem(PLASTER_AND_BANDAGE, "Plaster And Bandage");
        ItemHandler.registerItem(EMPTY_TEST_TUBE, "Empty Test Tube");
        ItemHandler.registerItem(EMPTY_SYRINGE, "Empty Syringe");
        ItemHandler.registerItem(GROWTH_SERUM, "Growth Serum");
        ItemHandler.registerItem(BREEDING_WAND, "Breeding Wand");
        ItemHandler.registerItem(BIRTHING_WAND, "Birthing_Wand");
        ItemHandler.registerItem(PREGNANCY_TEST, "Pregnancy Test");
        ItemHandler.registerItem(STORAGE_DISC, "Storage Disc");
        ItemHandler.registerItem(DISC_DRIVE, "Disc Reader");
        ItemHandler.registerItem(LASER, "Laser");
        ItemHandler.registerItem(DNA_NUCLEOTIDES, "DNA Base Material");
        ItemHandler.registerItem(PETRI_DISH, "Petri Dish");
        ItemHandler.registerItem(PETRI_DISH_AGAR, "Petri Dish Agar");
        ItemHandler.registerItem(PLANT_CELLS_PETRI_DISH, "Plant Cells Petri Dish");
        ItemHandler.registerItem(PADDOCK_SIGN, "Paddock Sign");
        ItemHandler.registerItem(ATTRACTION_SIGN, "Attraction Sign");
        ItemHandler.registerItem(MURAL, "Mural");
        ItemHandler.registerItem(DNA, "DNA");
        ItemHandler.registerItem(SOFT_TISSUE, "Soft Tissue");
        ItemHandler.registerItem(SYRINGE, "Syringe");
        ItemHandler.registerItem(EGG, "Dino Egg");
        ItemHandler.registerItem(HATCHED_EGG, "Hatched Egg");
        ItemHandler.registerItem(PLANT_SOFT_TISSUE, "Plant Soft Tissue");
        ItemHandler.registerItem(PLANT_DNA, "Plant DNA");
        ItemHandler.registerItem(IRON_BLADES, "Iron Blades");
        ItemHandler.registerItem(IRON_ROD, "Iron Rod");
        ItemHandler.registerItem(PLANT_CELLS, "Plant Cells");
        ItemHandler.registerItem(PLANT_CALLUS, "Plant Callus");
        ItemHandler.registerItem(TRACKER, "Tracker");
        ItemHandler.registerItem(BASIC_CIRCUIT, "Basic Circuit");
        ItemHandler.registerItem(ADVANCED_CIRCUIT, "Advanced Circuit");
        ItemHandler.registerItem(COMPUTER_SCREEN, "Computer Screen");
        ItemHandler.registerItem(KEYBOARD, "Keyboard");
        ItemHandler.registerItem(DNA_ANALYZER, "DNA Analyzer");
        ItemHandler.registerItem((Item)DINOSAUR_MEAT, "Dinosaur Meat");
        ItemHandler.registerItem((Item)DINOSAUR_STEAK, "Dinosaur Steak");
        ItemHandler.registerItem(PLANT_FOSSIL, "Plant Fossil");
        ItemHandler.registerItem(TWIG_FOSSIL, "Twig Fossil");
        ItemHandler.registerItem(AMBER_CANE, "Amber Cane");
        ItemHandler.registerItem(AMBER_KEYCHAIN, "Amber Keychain");
        ItemHandler.registerItem(MR_DNA_KEYCHAIN, "Mr DNA Keychain");
        ItemHandler.registerItem(DISPLAY_BLOCK_ITEM, "Display Block Item");
        ItemHandler.registerItem(DINO_SCANNER, "Dino Scanner");
        ItemHandler.registerItem(GYPSUM_POWDER, "Gypsum Powder");
        ItemHandler.registerItem(AJUGINUCULA_SMITHII_SEEDS, "Ajuginucula Smithii Seeds");
        ItemHandler.registerItem(AJUGINUCULA_SMITHII_LEAVES, "Ajuginucula Smithii Leaves");
        ItemHandler.registerItem(AJUGINUCULA_SMITHII_OIL, "Ajuginucula Smithii Oil");
        ItemHandler.registerItem(WILD_ONION, "Wild Onion");
        ItemHandler.registerItem(WILD_POTATO_SEEDS, "Wild Potato Seeds");
        ItemHandler.registerItem(WILD_POTATO, "Wild Potato");
        ItemHandler.registerItem(WILD_POTATO_COOKED, "Wild Potato Cooked");
        ItemHandler.registerItem(RHAMNUS_SEEDS, "Rhamnus Salicifolius Seeds");
        ItemHandler.registerItem(RHAMNUS_BERRIES, "Rhamnus Salicifolius Berries");
        ItemHandler.registerItem(GRACILARIA, "Gracilaria Coral");
        ItemHandler.registerItem(AULOPORA, "Aulopora Coral");
        ItemHandler.registerItem(CLADOCHONUS, "Cladochonus Coral");
        ItemHandler.registerItem(ENALLHELIA, "Enallhelia Coral");
        ItemHandler.registerItem(MICROSOLENA, "Microsolena Coral");
        ItemHandler.registerItem(HIPPURITES_RADIOSUS, "Hippurites Radiosus Coral");
        ItemHandler.registerItem(LITHOSTROTION, "Lithostrotion Coral");
        ItemHandler.registerItem(STYLOPHYLLOPSIS, "Stylophyllopsis Coral");
        ItemHandler.registerItem(LIQUID_AGAR, "Liquid Agar");
        ItemHandler.registerItem((Item)CHILEAN_SEA_BASS, "Chilean Sea Bass");
        ItemHandler.registerItem((Item)PHOENIX_FRUIT, "Phoenix Fruit");
        ItemHandler.registerItem(PHOENIX_SEEDS, "Phoenix Seeds");
        ItemHandler.registerItem(FINE_NET, "Fine Net");
        ItemHandler.registerItem(PLANKTON, "Plankton");
        ItemHandler.registerItem(KRILL, "Krill");
        ItemHandler.registerItem(CRICKETS, "Crickets");
        ItemHandler.registerItem(COCKROACHES, "Cockroaches");
        ItemHandler.registerItem(MEALWORM_BEETLES, "Mealworm Beetles");
        ItemHandler.registerItem(CAR_CHASSIS, "Car Chassis");
        ItemHandler.registerItem(ENGINE_SYSTEM, "Engine System");
        ItemHandler.registerItem(CAR_SEATS, "Car Seats");
        ItemHandler.registerItem(CAR_TIRE, "Car Tire");
        ItemHandler.registerItem(CAR_WINDSCREEN, "Car Windscreen");
        ItemHandler.registerItem(UNFINISHED_CAR, "Unfinished Car");
        ItemHandler.registerItem(VEHICLE_ITEM, "Vehicle Item");
        ItemHandler.registerItem((Item)JURASSICRAFT_THEME_DISC, "Disc JurassiCraft Theme");
        ItemHandler.registerItem((Item)TROODONS_AND_RAPTORS_DISC, "Disc Troodons And Raptors");
        ItemHandler.registerItem((Item)DONT_MOVE_A_MUSCLE_DISC, "Disc Don't Move A Muscle");
        ItemHandler.registerItem((Item)GOAT_RAW, "Goat Raw");
        ItemHandler.registerItem((Item)GOAT_COOKED, "Goat Cooked");
        ItemHandler.registerItem((Item)FUN_FRIES, "Fun Fries");
        ItemHandler.registerItem((Item)OILED_POTATO_STRIPS, "Oiled Potato Strips");
        ItemHandler.registerItem(WEST_INDIAN_LILAC_BERRIES, "West Indian Lilac Berries");
        ItemHandler.registerItem(LUNCH_BOX, "Lunch Box");
        ItemHandler.registerItem(STAMP_SET, "Stamp Set");
        ItemHandler.registerItem(INGEN_JOURNAL, "InGen Journal");
        ItemHandler.registerItem(DART_GUN, "Dart Gun");
        ItemHandler.registerItem(DART, "Dart");
        ItemHandler.registerItem(DART_TRANQUILIZER, "Tranquilizer Dart");
        ItemHandler.registerItem(DART_EUTHANIZATION, "Euthanization Dart");
        ItemHandler.registerItem(DART_TIPPED_POTION, "Potion Tipped Dart");
        for (TreeType type : TreeType.values()) {
            ItemHandler.registerTreeType(type);
        }
    }

    public static void registerOres() {
    }

    public static void registerTreeType(TreeType type) {
        String typeName = type.name();
        AncientDoorItem door = new AncientDoorItem((Block)BlockHandler.ANCIENT_DOORS.get((Object)type));
        ANCIENT_DOORS.put(type, door);
        ItemHandler.registerItem((Item)door, typeName + " Door Item");
    }

    public static void registerItem(Item item, String name) {
        String formattedName = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_").replaceAll("'", "");
        item.func_77655_b(formattedName);
        RegistryHandler.registerItem(item, formattedName);
    }
}

