/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.genetics.PlantDNA;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangUtils;

public class PlantSoftTissueItem
extends Item
implements SequencableItem {
    public PlantSoftTissueItem() {
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.PLANTS);
    }

    public static Plant getPlant(ItemStack stack) {
        Plant plant = PlantHandler.getPlantById(stack.func_77952_i());
        if (plant == null) {
            plant = PlantHandler.SMALL_ROYAL_FERN;
        }
        return plant;
    }

    public String func_77653_i(ItemStack stack) {
        this.getItemSubtypes(this);
        return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{plant}", LangUtils.getPlantName(PlantSoftTissueItem.getPlant(stack)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Plant> plants = new LinkedList<Plant>(PlantHandler.getPrehistoricPlantsAndTrees());
        HashMap<Plant, Integer> ids = new HashMap<Plant, Integer>();
        for (Plant plant : plants) {
            ids.put(plant, PlantHandler.getPlantId(plant));
        }
        Collections.sort(plants);
        if (this.func_194125_a(tab)) {
            for (Plant plant : plants) {
                subtypes.add((Object)new ItemStack((Item)this, 1, ((Integer)ids.get(plant)).intValue()));
            }
        }
    }

    @Override
    public boolean isSequencable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getSequenceOutput(ItemStack stack, Random random) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            PlantDNA dna = new PlantDNA(stack.func_77952_i(), SequencableItem.randomQuality(random));
            dna.writeToNBT(nbt);
        }
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
        output.func_77982_d(nbt);
        return output;
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        return this.getItemSubtypes(this);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        NBTTagCompound nbt = new NBTTagCompound();
        PlantDNA dna = new PlantDNA(inputItem.func_77952_i(), -1);
        dna.writeToNBT(nbt);
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
        output.func_77982_d(nbt);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(100.0f), (Object)output)});
    }
}

