/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.genetics.GeneticsHelper;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangUtils;

public class SoftTissueItem
extends Item
implements SequencableItem {
    public SoftTissueItem() {
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.DNA);
    }

    public static Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = EntityHandler.getDinosaurById(stack.func_77952_i());
        if (dinosaur == null) {
            dinosaur = EntityHandler.VELOCIRAPTOR;
        }
        return dinosaur;
    }

    public String func_77653_i(ItemStack stack) {
        return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{dino}", LangUtils.getDinoName(SoftTissueItem.getDinosaur(stack)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    @Override
    public boolean isSequencable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getSequenceOutput(ItemStack stack, Random random) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            int quality = SequencableItem.randomQuality(random);
            DinoDNA dna = new DinoDNA(EntityHandler.getDinosaurById(stack.func_77952_i()), quality, GeneticsHelper.randomGenetics(random));
            dna.writeToNBT(nbt);
        } else if (!nbt.func_74764_b("Dinosaur")) {
            nbt.func_74768_a("Dinosaur", stack.func_77952_i());
        }
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
        output.func_77982_d(nbt);
        return output;
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        return this.getItemSubtypes(this);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        NBTTagCompound nbt = new NBTTagCompound();
        DinoDNA dna = new DinoDNA(EntityHandler.getDinosaurById(inputItem.func_77952_i()), -1, "");
        dna.writeToNBT(nbt);
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
        output.func_77982_d(nbt);
        list.add(Pair.of((Object)Float.valueOf(100.0f), (Object)output));
        return list;
    }
}

