/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.tree.AncientDoubleSlabBlock;
import org.jurassicraft.server.block.tree.AncientSlabHalfBlock;

public class AncientSlabItemBlock
extends ItemBlock {
    private final BlockSlab singleSlab;
    private final BlockSlab doubleSlab;

    public AncientSlabItemBlock(Block block, AncientSlabHalfBlock singleSlab, AncientDoubleSlabBlock doubleSlab) {
        super(block);
        this.singleSlab = singleSlab;
        this.doubleSlab = doubleSlab;
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return this.singleSlab.func_150002_b(stack.func_77960_j());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() != 0 && player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == this.singleSlab) {
                BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
                if (facing == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) {
                    AxisAlignedBB collisionBox = state.func_185918_c(world, pos);
                    IBlockState doubleSlabState = this.doubleSlab.func_176223_P();
                    if (collisionBox != Block.field_185506_k && world.func_72855_b(collisionBox.func_186670_a(pos)) && world.func_180501_a(pos, doubleSlabState, 11)) {
                        SoundType sound = this.doubleSlab.func_185467_w();
                        world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                        stack.func_190918_g(1);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return this.tryPlace(player, stack, world, pos.func_177972_a(facing)) ? EnumActionResult.SUCCESS : super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        IBlockState iblockstate1;
        BlockPos placePos = pos;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.singleSlab) {
            boolean flag;
            boolean bl = flag = state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
            if (side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag) {
                return true;
            }
        }
        return (iblockstate1 = world.func_180495_p(pos = pos.func_177972_a(side))).func_177230_c() == this.singleSlab || super.func_179222_a(world, placePos, side, player, stack);
    }

    private boolean tryPlace(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.singleSlab) {
            AxisAlignedBB collisionBounds = state.func_185918_c(world, pos);
            if (collisionBounds != Block.field_185506_k && world.func_72855_b(collisionBounds.func_186670_a(pos)) && world.func_180501_a(pos, state, 11)) {
                SoundType soundtype = this.doubleSlab.func_185467_w();
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }
}

