/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.gui.DNACombinatorHybridizerGui;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.container.DNACombinatorHybridizerContainer;

public class SwitchHybridizerCombinatorMode
extends AbstractMessage<SwitchHybridizerCombinatorMode> {
    private BlockPos pos;
    private boolean hybridizer;
    private int dimension;

    public SwitchHybridizerCombinatorMode() {
    }

    public SwitchHybridizerCombinatorMode(BlockPos pos, boolean hybridizer, int dimension) {
        this.hybridizer = hybridizer;
        this.pos = pos;
        this.dimension = dimension;
    }

    public void onClientReceived(Minecraft minecraft, SwitchHybridizerCombinatorMode message, EntityPlayer player, MessageContext messageContext) {
        DNACombinatorHybridizerBlockEntity tile = (DNACombinatorHybridizerBlockEntity)player.field_70170_p.func_175625_s(message.pos);
        tile.setMode(message.hybridizer);
        GuiScreen screen = ClientProxy.MC.field_71462_r;
        if (screen instanceof DNACombinatorHybridizerGui) {
            ((DNACombinatorHybridizerContainer)((DNACombinatorHybridizerGui)screen).field_147002_h).updateSlots(message.hybridizer);
        }
    }

    public void onServerReceived(MinecraftServer minecraftServer, SwitchHybridizerCombinatorMode message, EntityPlayer player, MessageContext messageContext) {
        boolean mode = message.hybridizer;
        BlockPos pos = message.pos;
        DNACombinatorHybridizerBlockEntity tile = (DNACombinatorHybridizerBlockEntity)player.field_70170_p.func_175625_s(pos);
        tile.setMode(mode);
        JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new SwitchHybridizerCombinatorMode(pos, mode, message.dimension), new NetworkRegistry.TargetPoint(message.dimension, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof DNACombinatorHybridizerContainer) {
            ((DNACombinatorHybridizerContainer)openContainer).updateSlots(mode);
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.hybridizer);
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeInt(this.dimension);
    }

    public void fromBytes(ByteBuf buffer) {
        this.hybridizer = buffer.readBoolean();
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.dimension = buffer.readInt();
    }
}

