/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.period;

import net.minecraft.util.IStringSerializable;

public enum TimePeriod implements IStringSerializable
{
    QUATERNARY("quaternary", 2.588f, 0.0f),
    NEOGENE("neogene", 23.03f, 2.589f),
    PALEOGENE("paleogene", 66.0f, 23.04f),
    CRETACEOUS("cretaceous", 145.5f, 66.1f),
    JURASSIC("jurassic", 201.3f, 145.6f),
    TRIASSIC("triassic", 252.17f, 201.4f),
    PERMIAN("permian", 298.9f, 252.18f),
    CARBONIFEROUS("carboniferous", 358.9f, 299.0f),
    DEVONIAN("devonian", 419.2f, 359.0f),
    SILURIAN("silurian", 443.4f, 419.3f),
    ORDOVICIAN("ordovician", 485.4f, 443.5f),
    CAMBRIAN("cambrian", 541.0f, 485.5f),
    NONE("none", 0.0f, 0.0f);

    private final String name;
    private final float startTime;
    private final float endTime;

    private TimePeriod(String name, float startTime, float endTime) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static int getStartYLevel(TimePeriod period) {
        return 64 - (int)(period.getStartTime() != 0.0f ? period.getStartTime() * 64.0f / 541.0f : 0.0f);
    }

    public static int getEndYLevel(TimePeriod period) {
        return 64 - (int)(period.getEndTime() != 0.0f ? period.getEndTime() * 64.0f / 541.0f : 0.0f);
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public float getStartTime() {
        return this.startTime;
    }

    public float getEndTime() {
        return this.endTime;
    }
}

