/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.gui.CleaningStationGui;
import org.jurassicraft.client.gui.CultivateGui;
import org.jurassicraft.client.gui.DNAExtractorGui;
import org.jurassicraft.client.gui.DNASequencerGui;
import org.jurassicraft.client.gui.DNASynthesizerGui;
import org.jurassicraft.client.gui.EmbryoCalcificationMachineGui;
import org.jurassicraft.client.gui.EmbryonicMachineGui;
import org.jurassicraft.client.gui.FossilGrinderGui;
import org.jurassicraft.client.gui.SkeletonAssemblyGui;
import org.jurassicraft.server.api.CleanableItem;
import org.jurassicraft.server.api.ExtractableItem;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.api.JurassicIngredientItem;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.api.SynthesizableItem;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.AncientDoorBlock;
import org.jurassicraft.server.container.CleaningStationContainer;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.container.DNAExtractorContainer;
import org.jurassicraft.server.container.DNASynthesizerContainer;
import org.jurassicraft.server.container.EmbryoCalcificationMachineContainer;
import org.jurassicraft.server.container.EmbryonicMachineContainer;
import org.jurassicraft.server.container.FossilGrinderContainer;
import org.jurassicraft.server.container.SkeletonAssemblyContainer;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateInput;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateRecipeCreator;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.calcification.CalcificationInput;
import org.jurassicraft.server.plugin.jei.category.calcification.CalcificationRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.calcification.CalcificationRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.cleaningstation.CleanableInput;
import org.jurassicraft.server.plugin.jei.category.cleaningstation.CleaningStationRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.cleaningstation.CleaningStationRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.cultivate.CultivateInput;
import org.jurassicraft.server.plugin.jei.category.cultivate.CultivatorRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.cultivate.CultivatorRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.dnaextractor.DNAExtractorRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.dnaextractor.DNAExtractorRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.dnaextractor.ExtractorInput;
import org.jurassicraft.server.plugin.jei.category.dnasequencer.DNASequencerRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.dnasequencer.DNASequencerRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.dnasequencer.SequencerInput;
import org.jurassicraft.server.plugin.jei.category.dnasynthesizer.DNASequencerTransferHandler;
import org.jurassicraft.server.plugin.jei.category.dnasynthesizer.DNASynthesizerRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.dnasynthesizer.DNASynthesizerRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.dnasynthesizer.SynthesizerInput;
import org.jurassicraft.server.plugin.jei.category.embroyonicmachine.EmbryoInput;
import org.jurassicraft.server.plugin.jei.category.embroyonicmachine.EmbryonicRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.embroyonicmachine.EmbryonicRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.fossilgrinder.FossilGrinderRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.fossilgrinder.FossilGrinderRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.fossilgrinder.GrinderInput;
import org.jurassicraft.server.plugin.jei.category.incubator.IncubatorInput;
import org.jurassicraft.server.plugin.jei.category.incubator.IncubatorRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.incubator.IncubatorRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.moss.PeatInput;
import org.jurassicraft.server.plugin.jei.category.moss.PeatItem;
import org.jurassicraft.server.plugin.jei.category.moss.PeatRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.moss.PeatRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.skeletonassembly.SkeletonAssemblyRecipeCategory;
import org.jurassicraft.server.plugin.jei.category.skeletonassembly.SkeletonAssemblyRecipeWrapper;
import org.jurassicraft.server.plugin.jei.category.skeletonassembly.SkeletonInput;
import org.jurassicraft.server.plugin.jei.vanilla.TippedDartRecipeWrapper;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class JurassiCraftJEIPlugin
implements IModPlugin {
    public static final String FOSSIL_GRINDER = "jurassicraft.fossil_grinder";
    public static final String DNA_EXTRACTOR = "jurassicraft.dna_extractor";
    public static final String CLEANING_STATION = "jurassicraft.cleaning_station";
    public static final String DNA_SYNTHASIZER = "jurassicraft.dna_synthesizer";
    public static final String EMBRYOMIC_MACHINE = "jurassicraft.embryonic_machine";
    public static final String EMBRYO_CALCIFICATION_MACHINE = "jurassicraft.embryo_calcification_machine";
    public static final String SKELETON_ASSEMBLY = "jurassicraft.skeleton_assembly";
    public static final String DNA_SEQUENCER = "jurassicraft.dna_sequencer";
    public static final String CULTIVATEOR = "jurassicraft.cultivator";
    public static final String INCUBATOR = "jurassicraft.incubator";
    public static final String PEAT = "jurassicraft.peat";
    public static final String BUG_CRATE = "jurassicraft.bug_crate";

    private static <T> List<T> getDinos(Function<Dinosaur, T> func) {
        return JurassiCraftJEIPlugin.getDinos(func, dino -> true);
    }

    private static <T> List<T> getDinos(Function<Dinosaur, T> func, Predicate<Dinosaur> filter) {
        return EntityHandler.getRegisteredDinosaurs().stream().filter(filter).map(func).collect(Collectors.toList());
    }

    private static <T> List<T> getPlants(Function<Plant, T> func) {
        return PlantHandler.getPrehistoricPlantsAndTrees().stream().map(func).collect(Collectors.toList());
    }

    protected static <T> List<T> getAllItems(Function<ItemStack, JurassicIngredientItem> ingredientFunction, Function<ItemStack, T> tFunction) {
        ArrayList list = Lists.newArrayList();
        ForgeRegistries.ITEMS.getValuesCollection().stream().map(ItemStack::new).map(ingredientFunction).filter(Objects::nonNull).map(JurassicIngredientItem::getJEIRecipeTypes).forEach(l -> list.addAll(l.stream().map(tFunction).collect(Collectors.toList())));
        return list;
    }

    private static void addHollowClickHandler(IModRegistry registry, Class<? extends GuiContainer> guiContainerClass, Rectangle size, Rectangle ignore, String ... recipeCategoryUids) {
        registry.addRecipeClickArea(guiContainerClass, size.x, size.y, ignore.x - size.x, size.height, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x + ignore.width, size.y, size.x + size.width - (ignore.x + ignore.width), size.height, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x, size.y, ignore.width, ignore.y - size.y, recipeCategoryUids);
        registry.addRecipeClickArea(guiContainerClass, ignore.x, ignore.y + ignore.height, ignore.width, size.y + size.height - (ignore.y + ignore.height), recipeCategoryUids);
    }

    public void register(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        Collection<AncientDoorBlock> doors = BlockHandler.ANCIENT_DOORS.values();
        for (Block block : doors) {
            blacklist.addIngredientToBlacklist((Object)new ItemStack(block));
        }
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.CULTIVATOR_TOP, 1, Short.MAX_VALUE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.DISPLAY_BLOCK));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.KRILL_SWARM));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.PLANKTON_SWARM));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.RHAMNUS_SALICIFOLIUS_PLANT));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.AJUGINUCULA_SMITHII));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.WILD_ONION));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.WILD_POTATO_PLANT));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockHandler.GRACILARIA));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemHandler.HATCHED_EGG));
        registry.handleRecipes(GrinderInput.class, FossilGrinderRecipeWrapper::new, FOSSIL_GRINDER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.FOSSIL_GRINDER), new String[]{FOSSIL_GRINDER});
        registry.handleRecipes(ExtractorInput.class, DNAExtractorRecipeWrapper::new, DNA_EXTRACTOR);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_EXTRACTOR), new String[]{DNA_EXTRACTOR});
        registry.handleRecipes(PeatInput.class, PeatRecipeWrapper::new, PEAT);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.PEAT), new String[]{PEAT});
        registry.handleRecipes(BugCrateInput.class, BugCrateRecipeWrapper::new, BUG_CRATE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.BUG_CRATE), new String[]{BUG_CRATE});
        registry.handleRecipes(CleanableInput.class, CleaningStationRecipeWrapper::new, CLEANING_STATION);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.CLEANING_STATION), new String[]{CLEANING_STATION});
        registry.handleRecipes(SynthesizerInput.class, DNASynthesizerRecipeWrapper::new, DNA_SYNTHASIZER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_SYNTHESIZER), new String[]{DNA_SYNTHASIZER});
        registry.handleRecipes(EmbryoInput.class, EmbryonicRecipeWrapper::new, EMBRYOMIC_MACHINE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.EMBRYONIC_MACHINE), new String[]{EMBRYOMIC_MACHINE});
        registry.handleRecipes(CalcificationInput.class, CalcificationRecipeWrapper::new, EMBRYO_CALCIFICATION_MACHINE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.EMBRYO_CALCIFICATION_MACHINE), new String[]{EMBRYO_CALCIFICATION_MACHINE});
        registry.handleRecipes(SkeletonInput.class, SkeletonAssemblyRecipeWrapper::new, SKELETON_ASSEMBLY);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.SKELETON_ASSEMBLY), new String[]{SKELETON_ASSEMBLY});
        registry.handleRecipes(SequencerInput.class, DNASequencerRecipeWrapper::new, DNA_SEQUENCER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.DNA_SEQUENCER), new String[]{DNA_SEQUENCER});
        registry.handleRecipes(CultivateInput.class, CultivatorRecipeWrapper::new, CULTIVATEOR);
        NonNullList list = NonNullList.func_191196_a();
        BlockHandler.CULTIVATOR_BOTTOM.func_149666_a(CreativeTabs.field_78027_g, (NonNullList<ItemStack>)list);
        list.forEach(item -> registry.addRecipeCatalyst(item, new String[]{CULTIVATEOR}));
        registry.handleRecipes(IncubatorInput.class, IncubatorRecipeWrapper::new, INCUBATOR);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockHandler.INCUBATOR), new String[]{INCUBATOR});
        registry.addRecipeClickArea(FossilGrinderGui.class, 78, 33, 26, 19, new String[]{FOSSIL_GRINDER});
        registry.addRecipeClickArea(DNAExtractorGui.class, 75, 35, 26, 19, new String[]{DNA_EXTRACTOR});
        registry.addRecipeClickArea(CleaningStationGui.class, 78, 33, 26, 19, new String[]{CLEANING_STATION});
        registry.addRecipeClickArea(DNASynthesizerGui.class, 78, 33, 26, 19, new String[]{DNA_SYNTHASIZER});
        registry.addRecipeClickArea(EmbryonicMachineGui.class, 78, 33, 26, 19, new String[]{EMBRYOMIC_MACHINE});
        registry.addRecipeClickArea(EmbryoCalcificationMachineGui.class, 66, 30, 26, 19, new String[]{EMBRYO_CALCIFICATION_MACHINE});
        registry.addRecipeClickArea(SkeletonAssemblyGui.class, 106, 50, 26, 19, new String[]{SKELETON_ASSEMBLY});
        registry.addRecipeClickArea(DNASequencerGui.class, 86, 18, 23, 52, new String[]{DNA_SEQUENCER});
        JurassiCraftJEIPlugin.addHollowClickHandler(registry, CultivateGui.class, new Rectangle(98, 20, 64, 64), new Rectangle(116, 38, 27, 27), CULTIVATEOR);
        IRecipeTransferRegistry iRecipeTransferRegistry = registry.getRecipeTransferRegistry();
        iRecipeTransferRegistry.addRecipeTransferHandler(FossilGrinderContainer.class, FOSSIL_GRINDER, 0, 6, 12, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(DNAExtractorContainer.class, DNA_EXTRACTOR, 0, 2, 6, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(CleaningStationContainer.class, CLEANING_STATION, 0, 2, 8, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(DNASynthesizerContainer.class, DNA_SYNTHASIZER, 0, 3, 7, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(EmbryonicMachineContainer.class, EMBRYOMIC_MACHINE, 0, 3, 7, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(EmbryoCalcificationMachineContainer.class, EMBRYO_CALCIFICATION_MACHINE, 0, 2, 3, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler(SkeletonAssemblyContainer.class, SKELETON_ASSEMBLY, 1, 25, 26, 36);
        iRecipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new DNASequencerTransferHandler(registry.getJeiHelpers().recipeTransferHandlerHelper()), DNA_SEQUENCER);
        iRecipeTransferRegistry.addRecipeTransferHandler(CultivateContainer.class, CULTIVATEOR, 0, 1, 4, 36);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(GrindableItem::getGrindableItem, GrinderInput::new), FOSSIL_GRINDER);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(ExtractableItem::getExtractableItem, ExtractorInput::new), DNA_EXTRACTOR);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(PeatItem::getPeatItem, PeatInput::new), PEAT);
        registry.addRecipes(BugCrateRecipeCreator.getAllRecipes(), BUG_CRATE);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(CleanableItem::getCleanableItem, CleanableInput::new), CLEANING_STATION);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(SynthesizableItem::getSynthesizableItem, SynthesizerInput::new), DNA_SYNTHASIZER);
        registry.addRecipes(JurassiCraftJEIPlugin.getAllItems(SequencableItem::getSequencableItem, SequencerInput::new), DNA_SEQUENCER);
        registry.addRecipes(JurassiCraftJEIPlugin.getDinos(CultivateInput::new, dino -> dino.getMetadata().getBirthType() == Dinosaur.BirthType.LIVE_BIRTH), CULTIVATEOR);
        registry.addRecipes(JurassiCraftJEIPlugin.getDinos(IncubatorInput::new, dino -> dino.getMetadata().getBirthType() == Dinosaur.BirthType.EGG_LAYING), INCUBATOR);
        registry.addRecipes(JurassiCraftJEIPlugin.getDinos(CalcificationInput::new, dino -> dino.getMetadata().getBirthType() == Dinosaur.BirthType.EGG_LAYING), EMBRYO_CALCIFICATION_MACHINE);
        registry.addRecipes(JurassiCraftJEIPlugin.getDinos(EmbryoInput.DinosaurInput::new), EMBRYOMIC_MACHINE);
        registry.addRecipes(JurassiCraftJEIPlugin.getPlants(EmbryoInput.PlantInput::new), EMBRYOMIC_MACHINE);
        for (Dinosaur dinosaur : EntityHandler.getRegisteredDinosaurs()) {
            registry.addRecipes((Collection)Lists.newArrayList((Object[])new SkeletonInput[]{new SkeletonInput(dinosaur, false), new SkeletonInput(dinosaur, true)}), SKELETON_ASSEMBLY);
        }
        registry.addRecipes((Collection)ForgeRegistries.POTION_TYPES.getValuesCollection().stream().map(TippedDartRecipeWrapper::new).collect(Collectors.toList()), "minecraft.crafting");
        registry.addIngredientInfo((Object)new ItemStack(ItemHandler.GROWTH_SERUM), ItemStack.class, new String[]{"info.jei.serum"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_150898_a((Block)BlockHandler.DNA_EXTRACTOR)), ItemStack.class, new String[]{"info.jei.extractor"});
        registry.addIngredientInfo((Object)new ItemStack((Block)BlockHandler.CULTIVATOR_BOTTOM), ItemStack.class, new String[]{"info.jei.cultivator"});
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            ItemStack stack = new ItemStack((Block)BlockHandler.CULTIVATOR_BOTTOM, 1, i);
            registry.addIngredientInfo((Object)stack, ItemStack.class, new String[]{"info.jei.cultivator"});
        }
        NonNullList placablesListPre = NonNullList.func_191196_a();
        ItemHandler.ATTRACTION_SIGN.func_150895_a(CreativeTabs.field_78027_g, (NonNullList<ItemStack>)placablesListPre);
        ArrayList<ItemStack> placables = new ArrayList<ItemStack>();
        placables.addAll((Collection<ItemStack>)placablesListPre);
        placables.add(new ItemStack((Item)ItemHandler.PADDOCK_SIGN));
        placables.add(new ItemStack((Item)ItemHandler.MURAL));
        registry.addIngredientInfo(placables, ItemStack.class, new String[]{"info.jei.placables"});
        registry.addIngredientInfo((Object)new ItemStack(ItemHandler.PREGNANCY_TEST), ItemStack.class, new String[]{"info.jei.pregnancy_test"});
        Collection<Dinosaur> dinosaurs = EntityHandler.getDinosaurs().values();
        for (Dinosaur dinosaur : dinosaurs) {
            if (!dinosaur.shouldRegister()) continue;
            ItemStack stack = new ItemStack((Item)ItemHandler.HATCHED_EGG, 1, EntityHandler.getDinosaurId(dinosaur));
            registry.addIngredientInfo((Object)stack, ItemStack.class, new String[]{"info.jei.hatched_egg"});
        }
        registry.addIngredientInfo(new ArrayList<ItemStack>(Arrays.asList(new ItemStack((Item)ItemHandler.KRILL), new ItemStack((Item)ItemHandler.PLANKTON))), ItemStack.class, new String[]{"info.jei.krill_plankton"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_150898_a((Block)BlockHandler.DNA_COMBINATOR_HYBRIDIZER)), ItemStack.class, new String[]{"info.jei.combinator_hybridizer"});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FossilGrinderRecipeCategory(guiHelper), new DNAExtractorRecipeCategory(guiHelper), new CleaningStationRecipeCategory(guiHelper), new DNASynthesizerRecipeCategory(guiHelper), new EmbryonicRecipeCategory(guiHelper), new CalcificationRecipeCategory(guiHelper), new SkeletonAssemblyRecipeCategory(guiHelper), new DNASequencerRecipeCategory(guiHelper), new CultivatorRecipeCategory(guiHelper), new PeatRecipeCategory(guiHelper), new BugCrateRecipeCategory(guiHelper), new IncubatorRecipeCategory(guiHelper)});
    }
}

