/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei.category.bugcrate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jurassicraft.server.api.BreedableBug;
import org.jurassicraft.server.api.JurassicIngredientItem;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.item.BugItem;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateInput;
import org.jurassicraft.server.plugin.jei.category.bugcrate.BugCrateRecipeWrapper;

public class BugCrateRecipeCreator {
    public static List<BugCrateRecipeWrapper> getAllRecipes() {
        ArrayList<BugCrateRecipeWrapper> recipes = new ArrayList<BugCrateRecipeWrapper>();
        BugCrateRecipeCreator.addBugRecipes(recipes);
        return recipes;
    }

    private static void addBugRecipes(List<BugCrateRecipeWrapper> recipes) {
        List<BugCrateInput> list = BugCrateRecipeCreator.getBugs(BugCrateInput::new);
        for (BugCrateInput input : list) {
            List<FoodHelper.FoodKey> foods = FoodHelper.getFoods();
            ArrayList foodList = new ArrayList();
            foods.stream().filter(key -> ((BugItem)input.stack.func_77973_b()).getBreedings(new ItemStack(key.getItem())) > 0).forEach(key -> foodList.add(key));
            for (FoodHelper.FoodKey key2 : foodList) {
                BugCrateRecipeWrapper recipe = new BugCrateRecipeWrapper(input, new ItemStack(key2.getItem()));
                recipes.add(recipe);
            }
        }
    }

    protected static <T> List<T> getBugs(Function<ItemStack, T> function) {
        ArrayList list = Lists.newArrayList();
        ForgeRegistries.ITEMS.getValuesCollection().stream().map(ItemStack::new).map(BreedableBug::getBug).filter(Objects::nonNull).map(JurassicIngredientItem::getJEIRecipeTypes).forEach(stackList -> list.addAll(stackList.stream().map(function).collect(Collectors.toList())));
        return list;
    }
}

