/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei.category.dnasequencer;

import java.awt.Color;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.jurassicraft.server.plugin.jei.category.dnasequencer.DNASequencerRecipeWrapper;
import org.jurassicraft.server.plugin.jei.util.RecipeLayoutOutputSupplier;

public class DNASequencerRecipeCategory
implements IRecipeCategory<DNASequencerRecipeWrapper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/dna_sequencer.png");
    private final IDrawable background;
    private final String title;
    private final IDrawableAnimated arrow;
    private RecipeLayoutOutputSupplier outPutSupplier = null;

    public DNASequencerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 33, 3, 107, 32, 10, 10, 10, 10);
        this.title = I18n.func_74838_a((String)"tile.dna_sequencer.name");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(TEXTURE, 176, 0, 22, 6);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 64, 28);
        ItemStack stack = this.outPutSupplier.get();
        if (stack != null && !stack.func_190926_b()) {
            float value = stack.func_190925_c("jei_rendering_info").func_74760_g("Chance");
            String text = value + "%";
            if (value != 100.0f) {
                int width = minecraft.field_71466_p.func_78256_a(text);
                minecraft.field_71466_p.func_78276_b(text, 72 - width / 2, 47, Color.GRAY.getRGB());
            }
        }
    }

    public String getUid() {
        return "jurassicraft.dna_sequencer";
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, DNASequencerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        this.outPutSupplier = new RecipeLayoutOutputSupplier(recipeLayout, 0, false);
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        stackGroup.init(0, true, 20, 22);
        stackGroup.set(0, (List)inputs.get(0));
        stackGroup.init(1, true, 42, 22);
        stackGroup.set(1, (List)inputs.get(1));
        stackGroup.init(2, false, 89, 22);
        stackGroup.set(2, (List)outputs.get(0));
    }

    public String getModName() {
        return "JurassiCraft";
    }
}

