/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.util;

import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public enum GameRuleHandler {
    DINO_METABOLISM("dinoMetabolism", true),
    DINO_GROWTH("dinoGrowth", true),
    PLANT_SPREADING("plantSpreading", true),
    KILL_HERD_OUTCAST("killHerdOutcast", true);

    String name;
    Object defaultValue;
    GameRules.ValueType valueType;

    private GameRuleHandler(String name, boolean defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.valueType = GameRules.ValueType.BOOLEAN_VALUE;
    }

    private GameRuleHandler(String name, int defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.valueType = GameRules.ValueType.NUMERICAL_VALUE;
    }

    public static void register(World world) {
        GameRules gameRules = world.func_82736_K();
        for (GameRuleHandler rule : GameRuleHandler.values()) {
            if (gameRules.func_82765_e(rule.name)) continue;
            gameRules.func_180262_a(rule.name, String.valueOf(rule.defaultValue), rule.valueType);
        }
    }

    public boolean getBoolean(World world) {
        return world.func_82736_K().func_82766_b(this.name);
    }

    public int getInteger(World world) {
        return world.func_82736_K().func_180263_c(this.name);
    }
}

