/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.NestFossilBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.config.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.period.TimePeriod;

public enum WorldGenerator implements IWorldGenerator
{
    INSTANCE;


    public static void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        int randPosX;
        int i;
        Biome biome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        if (JurassiCraftConfig.MINERAL_GENERATION.petrifiedTreeGeneration) {
            i = 0;
            while ((double)i < world.field_73011_w.getHorizon() * 0.0125) {
                randPosX = chunkX + random.nextInt(16) + 8;
                int randPosZ = chunkZ + random.nextInt(16) + 8;
                int randPosY = random.nextInt(Math.max(1, world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 10));
                WorldGenerator.generatePetrifiedTree(world, TreeType.values()[random.nextInt(TreeType.values().length)], randPosX, randPosY, randPosZ, random);
                ++i;
            }
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.fossilGeneration) {
            for (i = 0; i < 32; ++i) {
                Dinosaur dinosaur;
                randPosX = chunkX + random.nextInt(16);
                int randPosY = random.nextInt(64);
                int randPosZ = chunkZ + random.nextInt(16);
                TimePeriod period = null;
                for (TimePeriod p : TimePeriod.values()) {
                    if (randPosY >= TimePeriod.getEndYLevel(p) || randPosY <= TimePeriod.getStartYLevel(p)) continue;
                    period = p;
                    break;
                }
                if (period == null) continue;
                randPosY += random.nextInt(8) - 4;
                List<Dinosaur> dinos = EntityHandler.getDinosaursFromPeriod(period);
                if (dinos == null || dinos.size() <= 0 || !(dinosaur = dinos.get(random.nextInt(dinos.size()))).shouldRegister()) continue;
                int meta = BlockHandler.getMetadata(dinosaur);
                new WorldGenMinable(BlockHandler.getFossilBlock(dinosaur).func_176203_a(meta), 5).func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
            }
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.nestFossilGeneration) {
            int nestChance = 100;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                nestChance = 30;
            }
            if (random.nextInt(nestChance) == 0) {
                BlockPos pos = new BlockPos(chunkX + 8 + random.nextInt(16), random.nextInt(20) + 30, chunkZ + 8 + random.nextInt(16));
                IBlockState nest = BlockHandler.NEST_FOSSIL.func_176223_P().func_177226_a(NestFossilBlock.VARIANT, (Comparable)((Object)NestFossilBlock.Variant.values()[random.nextInt(NestFossilBlock.Variant.values().length)]));
                IBlockState trackway = BlockHandler.FOSSILIZED_TRACKWAY.func_176223_P().func_177226_a(FossilizedTrackwayBlock.VARIANT, (Comparable)((Object)FossilizedTrackwayBlock.TrackwayType.values()[random.nextInt(FossilizedTrackwayBlock.TrackwayType.values().length)])).func_177226_a((IProperty)FossilizedTrackwayBlock.FACING, (Comparable)EnumFacing.func_176731_b((int)random.nextInt(4)));
                int size = random.nextInt(3) + 6;
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        BlockPos generationPos = pos.func_177982_a(x, 0, z);
                        if (world.func_175623_d(generationPos) || world.func_180495_p(generationPos).func_185904_a().func_76224_d()) continue;
                        IBlockState state = null;
                        if (random.nextFloat() < 0.8f) {
                            state = random.nextFloat() < 0.1f ? trackway : (random.nextFloat() < 0.6f ? Blocks.field_150351_n.func_176223_P() : Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)(random.nextBoolean() ? EnumDyeColor.WHITE : EnumDyeColor.SILVER)));
                        }
                        if (state == null) continue;
                        world.func_175656_a(generationPos, state);
                    }
                }
                for (int i2 = 0; i2 < random.nextInt(2) + 1; ++i2) {
                    BlockPos generationPos = pos.func_177982_a(random.nextInt(size), 0, random.nextInt(size));
                    if (world.func_175623_d(generationPos) || world.func_180495_p(generationPos).func_185904_a().func_76224_d()) continue;
                    world.func_175656_a(generationPos, nest);
                }
            }
        }
        BlockMatcher defaultPredicate = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
        if (JurassiCraftConfig.MINERAL_GENERATION.amberGeneration) {
            WorldGenerator.generateOre(world, chunkX, chunkZ, 20, 8, 3, BlockHandler.AMBER_ORE.func_176223_P(), random, (Predicate<IBlockState>)defaultPredicate);
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.iceShardGeneration) {
            WorldGenerator.generateOre(world, chunkX, chunkZ, 64, 8, 1, BlockHandler.ICE_SHARD.func_176223_P(), random, (Predicate<IBlockState>)defaultPredicate);
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.gypsumGeneration) {
            WorldGenerator.generateOre(world, chunkX, chunkZ, 128, 32, 10, BlockHandler.GYPSUM_STONE.func_176223_P(), random, (Predicate<IBlockState>)defaultPredicate);
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.phaneriticGeneration) {
            WorldGenerator.generateOre(world, chunkX, chunkZ, 98, 18, 16, BlockHandler.PHANERITIC.func_176223_P(), random, (Predicate<IBlockState>)defaultPredicate);
        }
    }

    public static void generateOre(World world, int chunkX, int chunkZ, int minHeight, int veinsPerChunk, int veinSize, IBlockState state, Random random, Predicate<IBlockState> predicate) {
        WorldGenMinable worldGenMinable = new WorldGenMinable(state, veinSize, predicate);
        for (int i = 0; i < veinsPerChunk; ++i) {
            int randPosX = chunkX + random.nextInt(16);
            int randPosY = random.nextInt(minHeight);
            int randPosZ = chunkZ + random.nextInt(16);
            worldGenMinable.func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
        }
    }

    private static void generatePetrifiedTree(World world, TreeType treeType, int x, int y, int z, Random rand) {
        float rotX = (float)(rand.nextDouble() * 360.0);
        float rotY = (float)(rand.nextDouble() * 360.0) - 180.0f;
        IBlockState state = BlockHandler.PETRIFIED_LOGS.get((Object)treeType).func_176223_P();
        float horizontal = MathHelper.func_76134_b((float)(rotX * (float)Math.PI / 180.0f));
        float vertical = MathHelper.func_76126_a((float)(rotX * (float)Math.PI / 180.0f));
        float xOffset = -MathHelper.func_76126_a((float)(rotY * (float)Math.PI / 180.0f)) * horizontal;
        float yOffset = MathHelper.func_76134_b((float)(rotY * (float)Math.PI / 180.0f)) * horizontal;
        for (int i = 0; i < rand.nextInt(7) + 3; ++i) {
            BlockPos pos;
            Block previousBlock;
            int blockX = x + Math.round(xOffset * (float)i);
            int blockY = y + Math.round(vertical * (float)i);
            int blockZ = z + Math.round(yOffset * (float)i);
            if (blockY <= 0 || blockY >= 256 || (previousBlock = world.func_180495_p(pos = new BlockPos(blockX, blockY, blockZ)).func_177230_c()) == Blocks.field_150357_h || previousBlock == Blocks.field_150350_a) continue;
            world.func_175656_a(pos, state);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            WorldGenerator.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
        }
    }
}

