/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.AncientItemHoldingBlockEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.villager.VillagerHandler;
import org.jurassicraft.server.world.loot.Loot;

public class FossilDigsite
extends StructureVillagePieces.Village {
    private int count;
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;
    private int structureType;
    private int villagerCount = 0;

    public FossilDigsite() {
    }

    public FossilDigsite(StructureVillagePieces.Start start, Random random, int type, StructureBoundingBox bounds, EnumFacing facing, int structureType) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
        this.structureType = structureType;
    }

    private static ResourceLocation getResource(int type) {
        return new ResourceLocation("jurassicraft", "fossildigsite_" + type);
    }

    public void func_186164_a(EnumFacing facing) {
        super.func_186164_a(facing);
        this.coordBaseMode = facing;
        if (facing == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_186222_a(true);
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, bounds);
            if (this.field_143015_k < 0) {
                return true;
            }
        }
        this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 13, 0);
        if (this.structureType == 3) {
            BlockPos offset3 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(0, -12, 0));
            this.field_74887_e.func_78886_a(offset3.func_177958_n(), offset3.func_177956_o(), offset3.func_177952_p());
        } else if (this.structureType == 1) {
            BlockPos offset1 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(0, -6, 0));
            this.field_74887_e.func_78886_a(offset1.func_177958_n(), offset1.func_177956_o(), offset1.func_177952_p());
        } else if (this.structureType == 2) {
            BlockPos offset2 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(0, -9, 0));
            this.field_74887_e.func_78886_a(offset2.func_177958_n(), offset2.func_177956_o(), offset2.func_177952_p());
        }
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, FossilDigsite.getResource(this.structureType));
        int sizeRot = this.structureType == 3 ? 8 : (this.structureType == 2 ? 7 : 6);
        int ox = this.rotation == Rotation.CLOCKWISE_90 && this.mirror == Mirror.NONE ? sizeRot : 0;
        int oz = this.rotation == Rotation.NONE && this.mirror == Mirror.LEFT_RIGHT ? sizeRot : 0;
        BlockPos lowerCorner = new BlockPos(this.field_74887_e.field_78897_a + ox, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + oz);
        if (lowerCorner.func_177956_o() <= 0) {
            return false;
        }
        settings.func_186223_a(new StructureBoundingBox(this.field_74887_e.field_78897_a + ox, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + oz, this.field_74887_e.field_78893_d + ox, this.field_74887_e.field_78892_f, this.field_74887_e.field_78892_f + oz));
        Map dataBlocks2 = template.func_186258_a(lowerCorner, settings);
        HashMap<BlockPos, IBlockState> defaultBlocks = this.getWorldDefaultBlocks(dataBlocks2, world);
        template.func_186260_a(world, lowerCorner, settings);
        this.spawnPaleontologist(world, random);
        Map dataBlocks = template.func_186258_a(lowerCorner, settings);
        Map<BlockPos, String> dataBlocksClone = dataBlocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.setDynamicBlocks(dataBlocks, dataBlocksClone, world, random, defaultBlocks);
        ++this.count;
        return true;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("count", this.count);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
        super.func_143011_b(tagCompound, templateManager);
        this.count = tagCompound.func_74762_e("count");
    }

    private void spawnPaleontologist(World world, Random random) {
        if (random.nextInt(2) == 0 && this.villagerCount < 2) {
            EntityZombieVillager paleontologist = null;
            if (this.field_189929_i) {
                paleontologist = new EntityZombieVillager(world);
                paleontologist.func_190733_a(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)VillagerHandler.PALEONTOLOGIST));
            } else {
                paleontologist = new EntityVillager(world, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)VillagerHandler.PALEONTOLOGIST));
            }
            paleontologist.func_70107_b((double)(this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2), (double)(this.field_74887_e.field_78895_b + 3), (double)(this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2));
            world.func_72838_d((Entity)paleontologist);
            ++this.villagerCount;
        }
    }

    private HashMap<BlockPos, IBlockState> getWorldDefaultBlocks(Map<BlockPos, String> dataBlocks, World world) {
        HashMap<BlockPos, IBlockState> defaultBlocks = new HashMap<BlockPos, IBlockState>();
        dataBlocks.forEach((pos, type) -> {
            switch (type) {
                case "Fossile2": {
                    defaultBlocks.put((BlockPos)pos, world.func_180495_p(pos));
                }
            }
        });
        return defaultBlocks;
    }

    private void setDynamicBlocks(Map<BlockPos, String> dataBlocks, Map<BlockPos, String> dataBlocksClone, World world, Random random, HashMap<BlockPos, IBlockState> defaultBlocks) {
        Dinosaur dinoType = EntityHandler.getDinosaurs().values().stream().findAny().get();
        dataBlocks.forEach((pos, type) -> {
            int spawnFossile = 0;
            switch (type) {
                case "Stair": {
                    BlockPos stair = pos.func_177977_b();
                    world.func_175656_a(stair, this.func_175847_a(world.func_180495_p(stair)));
                    world.func_175698_g(pos);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Chest": {
                    ((TileEntityChest)world.func_175625_s(pos.func_177977_b())).func_189404_a(Loot.FOSSIL_DIGSITE_LOOT, random.nextLong());
                    world.func_175698_g(pos);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Log": {
                    if (this.rotation == Rotation.CLOCKWISE_90) {
                        world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X)));
                    } else {
                        world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z)));
                    }
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Log2": {
                    if (this.rotation == Rotation.CLOCKWISE_90) {
                        world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z)));
                    } else {
                        world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X)));
                    }
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Log1": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P()));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Fence": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_180407_aO.func_176223_P()));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Fossile": {
                    spawnFossile = random.nextInt(2);
                    if (spawnFossile == 0) {
                        world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
                    } else {
                        world.func_175656_a(pos, BlockHandler.getFossilBlock(dinoType).func_176223_P());
                    }
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Fossile2": {
                    spawnFossile = random.nextInt(2);
                    if (spawnFossile != 0) {
                        world.func_175656_a(pos, BlockHandler.getFossilBlock(dinoType).func_176223_P());
                    }
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Shovel": {
                    world.func_175656_a(pos, BlockHandler.ANCIENT_ITEM_HOLDING_BLOCK.func_176223_P());
                    AncientItemHoldingBlockEntity tile = (AncientItemHoldingBlockEntity)world.func_175625_s(pos);
                    if (tile != null) {
                        int shovelYN = random.nextInt(2);
                        int durability = random.nextInt(229) + 20;
                        if (shovelYN == 1) {
                            tile.setDisplayItemStack(new ItemStack(Items.field_151037_a, 1, durability));
                        } else {
                            tile.setDisplayItemStack(new ItemStack(Items.field_151035_b, 1, durability));
                        }
                        tile.setDisplayItemYOffset(0.5f);
                    }
                    dataBlocksClone.remove(pos);
                }
            }
        });
        dataBlocksClone.forEach((pos, type) -> {
            switch (type) {
                case "Torch": {
                    if (this.field_189929_i) break;
                    world.func_180501_a(pos, Blocks.field_150478_aa.func_176223_P(), 2);
                }
            }
        });
        dataBlocksClone.clear();
    }

    public static class CreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
            return new StructureVillagePieces.PieceWeight(FossilDigsite.class, 1, MathHelper.func_76136_a((Random)random, (int)0, (int)1));
        }

        public Class<?> getComponentClass() {
            return FossilDigsite.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int minX, int minY, int minZ, EnumFacing facing, int componentType) {
            int randomValue = random.nextInt(100);
            int type = -1;
            int width = 0;
            int height = 13;
            int depth = 0;
            if (randomValue < 50) {
                type = 3;
                width = 9;
                depth = 9;
            } else if (randomValue < 80) {
                type = 1;
                width = 8;
                depth = 7;
            } else {
                type = 2;
                width = 8;
                depth = 8;
            }
            StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)minX, (int)minY, (int)minZ, (int)0, (int)0, (int)0, (int)width, (int)height, (int)depth, (EnumFacing)facing);
            return StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bounds) == null ? new FossilDigsite(startPiece, random, componentType, bounds, facing, type) : null;
        }
    }
}

