/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.structure;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jurassicraft.server.config.JurassiCraftConfig;

public class StructureUtils {
    private static final String DATA_ID = "jurassicraft_structure_info";

    @Nonnull
    public static StructureData getStructureData() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        if (world == null) {
            throw new RuntimeException("Overworld returned null");
        }
        StructureData data = (StructureData)world.func_72943_a(StructureData.class, DATA_ID);
        if (data == null) {
            data = new StructureData(DATA_ID);
            data.func_76185_a();
            world.func_72823_a(DATA_ID, (WorldSavedData)data);
        }
        return data;
    }

    public static class StructureData
    extends WorldSavedData {
        private boolean visitorCenter;
        private boolean raptorPaddock;
        private BlockPos visitorCenterPosition;

        public StructureData(String string) {
            super(string);
            this.visitorCenter = JurassiCraftConfig.STRUCTURE_GENERATION.visitorcentergeneration;
            this.raptorPaddock = JurassiCraftConfig.STRUCTURE_GENERATION.raptorgeneration;
            if (!string.equals(StructureUtils.DATA_ID)) {
                throw new RuntimeException("Invalid identifier: " + string);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound.func_74757_a("VisitorCenter", this.visitorCenter);
            compound.func_74757_a("RaptorPaddock", this.raptorPaddock);
            compound.func_74772_a("VisitorCenterBlockPosition", this.visitorCenterPosition.func_177986_g());
            return compound;
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.visitorCenter = nbt.func_74767_n("VisitorCenter");
            this.raptorPaddock = nbt.func_74767_n("RaptorPaddock");
            this.visitorCenterPosition = BlockPos.func_177969_a((long)nbt.func_74763_f("VisitorCenterBlockPosition"));
        }

        public boolean isVisitorCenter() {
            return this.visitorCenter;
        }

        public boolean isRaptorPaddock() {
            return this.raptorPaddock;
        }

        public BlockPos getVisitorCenterPosition() {
            return this.visitorCenterPosition;
        }

        public void setVisitorCenterPosition(BlockPos visitorCenterPosition) {
            this.visitorCenterPosition = visitorCenterPosition;
            this.func_76185_a();
        }
    }
}

