/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.ICrashCallable;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.common.book.Book;

public class BookCrashHandler
implements ICrashCallable {
    private static final String INDENT = "\n\t\t";

    public String getLabel() {
        return "Patchouli open book context";
    }

    public String call() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof GuiBook)) {
            return "n/a";
        }
        GuiBook gui = (GuiBook)screen;
        Book book = gui.book;
        StringBuilder builder = new StringBuilder(INDENT);
        builder.append("Open book: ").append(book.resourceLoc);
        if (gui instanceof GuiBookEntry) {
            builder.append(INDENT).append("Current entry: ").append(((GuiBookEntry)gui).getEntry().getResource());
        } else if (gui instanceof GuiBookEntryList) {
            builder.append(INDENT).append("Search query: ").append(((GuiBookEntryList)gui).getSearchQuery());
        }
        builder.append(INDENT).append("Current page spread: ").append(gui.getPage());
        if (book.contents.isErrored()) {
            Exception ex = book.contents.getException();
            builder.append(INDENT).append("Book loading error: ");
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                ex.printStackTrace(pw);
                builder.append(sw.toString().replaceAll("\n", INDENT));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.toString();
    }
}

