/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class SubTileSpectranthemum
extends SubTileFunctional {
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int COST = 24;
    private static final int RANGE = 2;
    private static final int BIND_RANGE = 12;
    private static final String TAG_TELEPORTED = "Botania_TPd";
    private BlockPos bindPos = new BlockPos(0, -1, 0);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.supertile.func_145831_w().field_72995_K && this.redstoneSignal == 0 && this.supertile.func_145831_w().func_175667_e(this.bindPos)) {
            BlockPos pos = this.supertile.func_174877_v();
            boolean did = false;
            List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(3, 3, 3)));
            int slowdown = this.getSlowdownFactor();
            for (EntityItem item : items) {
                int cost;
                Item sitem;
                ItemStack stack;
                if (item.field_70292_b < 60 + slowdown || item.field_70128_L || item.getEntityData().func_74767_n(TAG_TELEPORTED) || (stack = item.func_92059_d()).func_190926_b() || (sitem = stack.func_77973_b()) instanceof IManaItem || this.mana < (cost = stack.func_190916_E() * 24)) continue;
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                item.func_70107_b((double)this.bindPos.func_177958_n() + 0.5, (double)this.bindPos.func_177956_o() + 1.5, (double)this.bindPos.func_177952_p() + 0.5);
                item.getEntityData().func_74757_a(TAG_TELEPORTED, true);
                item.field_70179_y = 0.0;
                item.field_70181_x = 0.0;
                item.field_70159_w = 0.0;
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                this.mana -= cost;
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    static void spawnExplosionParticles(Entity item, int p) {
        PacketHandler.sendToNearby(item.field_70170_p, new BlockPos(item), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ITEM_SMOKE, item.field_70165_t, item.field_70163_u, item.field_70161_v, item.func_145782_y(), p));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 2);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 10009855;
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!bound && !pos.equals((Object)this.bindPos) && pos.func_177951_i((Vec3i)this.supertile.func_174877_v()) <= 144.0 && !pos.equals((Object)this.supertile.func_174877_v())) {
            this.bindPos = pos;
            this.sync();
            return true;
        }
        return bound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBinding() {
        return Minecraft.func_71410_x().field_71439_g.func_70093_af() && this.bindPos.func_177956_o() != -1 ? this.bindPos : super.getBinding();
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.spectranthemum;
    }
}

