/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemIncenseStick
extends ItemMod
implements IBrewItem,
IBrewContainer {
    private static final String TAG_BREW_KEY = "brewKey";
    public static final int TIME_MULTIPLIER = 60;

    public ItemIncenseStick() {
        super("incenseStick");
        this.func_77625_d(1);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack brewStack = this.getItemForBrew(BotaniaAPI.brewMap.get(s), new ItemStack((Item)this));
                if (brewStack.func_190926_b()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaAPI.fallbackBrew) {
            this.addStringToTooltip(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"botaniamisc.notInfused", (Object[])new Object[0]), list);
            return;
        }
        this.addStringToTooltip(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"botaniamisc.brewOf", (Object[])new Object[]{I18n.func_135052_a((String)brew.getUnlocalizedName(stack), (Object[])new Object[0])}), list);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
            PotionEffect longEffect = new PotionEffect(effect.func_188419_a(), effect.func_76459_b() * 60, effect.func_76458_c(), false, true);
            this.addStringToTooltip(" " + format + I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + (effect.func_76458_c() == 0 ? "" : " " + I18n.func_135052_a((String)("botania.roman" + (effect.func_76458_c() + 1)), (Object[])new Object[0])) + TextFormatting.GRAY + (effect.func_188419_a().func_76403_b() ? "" : " (" + Potion.func_188410_a((PotionEffect)longEffect, (float)1.0f) + ")"), list);
        }
    }

    void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemIncenseStick.setBrew(stack, brew.getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseIncense() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).func_188419_a().func_76403_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack brewStack = new ItemStack((Item)this);
        ItemIncenseStick.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }
}

