/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDynamic
extends PacketBase {
    private int type;
    private Object identifier;
    private ArrayList<Object> sendData;
    private ByteBuf payloadData;

    public PacketDynamic() {
    }

    public PacketDynamic(Entity entity) {
        super(GCCoreUtil.getDimensionID(entity.field_70170_p));
        assert (entity instanceof IPacketReceiver) : "Entity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 0;
        this.identifier = new Integer(entity.func_145782_y());
        this.sendData = new ArrayList();
        ((IPacketReceiver)entity).getNetworkedData(this.sendData);
    }

    public PacketDynamic(TileEntity tile) {
        super(GCCoreUtil.getDimensionID(tile.func_145831_w()));
        assert (tile instanceof IPacketReceiver) : "TileEntity does not implement " + IPacketReceiver.class.getSimpleName();
        this.type = 1;
        this.identifier = tile.func_174877_v();
        this.sendData = new ArrayList();
        ((IPacketReceiver)tile).getNetworkedData(this.sendData);
    }

    public boolean isEmpty() {
        return this.sendData.isEmpty();
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type);
        switch (this.type) {
            case 0: {
                buffer.writeInt(((Integer)this.identifier).intValue());
                break;
            }
            case 1: {
                BlockPos bp = (BlockPos)this.identifier;
                buffer.writeInt(bp.func_177958_n());
                buffer.writeInt(bp.func_177956_o());
                buffer.writeInt(bp.func_177952_p());
            }
        }
        ByteBuf payloadData = Unpooled.buffer();
        try {
            NetworkUtil.encodeData(payloadData, this.sendData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int readableBytes = payloadData.readableBytes();
        buffer.writeInt(readableBytes);
        buffer.writeBytes(payloadData);
    }

    @Override
    public void decodeInto(ByteBuf buffer) throws IndexOutOfBoundsException {
        super.decodeInto(buffer);
        this.type = buffer.readInt();
        switch (this.type) {
            case 0: {
                this.identifier = new Integer(buffer.readInt());
                int length = buffer.readInt();
                this.payloadData = Unpooled.copiedBuffer((ByteBuf)buffer.readBytes(length));
                break;
            }
            case 1: {
                this.identifier = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
                int length = buffer.readInt();
                this.payloadData = Unpooled.copiedBuffer((ByteBuf)buffer.readBytes(length));
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handleData(Side.CLIENT, player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handleData(Side.SERVER, player);
    }

    private void handleData(Side side, EntityPlayer player) {
        switch (this.type) {
            case 0: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.identifier).intValue());
                if (!(entity instanceof IPacketReceiver)) break;
                if (this.payloadData.readableBytes() > 0) {
                    ((IPacketReceiver)entity).decodePacketdata(this.payloadData);
                }
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP) || entity == null) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(entity), (EntityPlayerMP)player);
                break;
            }
            case 1: {
                TileEntity tile;
                BlockPos bp = (BlockPos)this.identifier;
                if (!player.field_70170_p.func_175668_a(bp, false) || !((tile = player.field_70170_p.func_175625_s(bp)) instanceof IPacketReceiver)) break;
                if (this.payloadData.readableBytes() > 0) {
                    ((IPacketReceiver)tile).decodePacketdata(this.payloadData);
                }
                if (side != Side.SERVER || !(player instanceof EntityPlayerMP) || tile == null) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamic(tile), (EntityPlayerMP)player);
            }
        }
    }
}

