/*
 * Decompiled with CFR 0.152.
 */
package cofh.shade.com.typesafe.config.impl;

import cofh.shade.com.typesafe.config.ConfigException;
import cofh.shade.com.typesafe.config.impl.AbstractConfigObject;
import cofh.shade.com.typesafe.config.impl.AbstractConfigValue;
import cofh.shade.com.typesafe.config.impl.ConfigImpl;
import cofh.shade.com.typesafe.config.impl.ResolveContext;
import cofh.shade.com.typesafe.config.impl.ResolveReplacer;
import cofh.shade.com.typesafe.config.impl.SubstitutionExpression;
import java.util.IdentityHashMap;
import java.util.Map;

final class ResolveSource {
    private final AbstractConfigObject root;
    private final Map<AbstractConfigValue, ResolveReplacer> replacements;

    ResolveSource(AbstractConfigObject root) {
        this.root = root;
        this.replacements = new IdentityHashMap<AbstractConfigValue, ResolveReplacer>();
    }

    private static AbstractConfigValue findInObject(AbstractConfigObject obj, ResolveContext context, SubstitutionExpression subst) throws AbstractConfigValue.NotPossibleToResolve {
        return obj.peekPath(subst.path(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractConfigValue lookupSubst(ResolveContext context, SubstitutionExpression subst, int prefixLength) throws AbstractConfigValue.NotPossibleToResolve {
        context.trace(subst);
        try {
            AbstractConfigValue result = ResolveSource.findInObject(this.root, context, subst);
            if (result == null) {
                SubstitutionExpression unprefixed = subst.changePath(subst.path().subPath(prefixLength));
                context.untrace();
                context.trace(unprefixed);
                if (prefixLength > 0) {
                    result = ResolveSource.findInObject(this.root, context, unprefixed);
                }
                if (result == null && context.options().getUseSystemEnvironment()) {
                    result = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), context, unprefixed);
                }
            }
            if (result != null) {
                result = context.resolve(result);
            }
            AbstractConfigValue abstractConfigValue = result;
            return abstractConfigValue;
        }
        finally {
            context.untrace();
        }
    }

    void replace(AbstractConfigValue value, ResolveReplacer replacer) {
        ResolveReplacer old = this.replacements.put(value, replacer);
        if (old != null) {
            throw new ConfigException.BugOrBroken("should not have replaced the same value twice: " + value);
        }
    }

    void unreplace(AbstractConfigValue value) {
        ResolveReplacer replacer = this.replacements.remove(value);
        if (replacer == null) {
            throw new ConfigException.BugOrBroken("unreplace() without replace(): " + value);
        }
    }

    private AbstractConfigValue replacement(ResolveContext context, AbstractConfigValue value) throws AbstractConfigValue.NotPossibleToResolve {
        ResolveReplacer replacer = this.replacements.get(value);
        if (replacer == null) {
            return value;
        }
        return replacer.replace(context);
    }

    AbstractConfigValue resolveCheckingReplacement(ResolveContext context, AbstractConfigValue original) throws AbstractConfigValue.NotPossibleToResolve {
        AbstractConfigValue replacement = this.replacement(context, original);
        if (replacement != original) {
            return context.resolve(replacement);
        }
        AbstractConfigValue resolved = original.resolveSubstitutions(context);
        return resolved;
    }
}

