/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.melee.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.EntityUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;

public class FryPan
extends TinkerToolCore {
    protected static final UUID FRYPAN_CHARGE_BONUS = UUID.fromString("b8f6d5f0-8d5a-11e6-ae22-56b6b6499611");

    public FryPan() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.panHead));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List<ItemStack>)subItems, new Material[0]);
            ItemStack tool = this.getInfiTool("Bane of Pigs");
            if (tool != null) {
                for (int i = 0; i < 125; ++i) {
                    TinkerModifiers.modFiery.apply(tool);
                }
                if (this.hasValidMaterials(tool)) {
                    subItems.add((Object)tool);
                }
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        Vec3d look;
        if (world.field_72995_K) {
            return;
        }
        float progress = Math.min(1.0f, (float)(this.func_77626_a(stack) - timeLeft) / 30.0f);
        float strength = 0.1f + 2.5f * progress * progress;
        float range = 3.2f;
        Vec3d eye = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        RayTraceResult mop = EntityUtil.raytraceEntity((Entity)player, eye, look = player.func_70676_i(1.0f), range, true);
        if (mop == null) {
            return;
        }
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            boolean flamingStrike;
            Entity entity = mop.field_72308_g;
            double x = look.field_72450_a * (double)strength;
            double y = look.field_72448_b / 3.0 * (double)strength + (double)0.1f + (double)(0.4f * progress);
            double z = look.field_72449_c * (double)strength;
            AttributeModifier modifier = new AttributeModifier(FRYPAN_CHARGE_BONUS, "Frypan charge bonus", (double)(progress * 5.0f), 0);
            boolean bl = flamingStrike = progress >= 1.0f && !entity.func_70027_ad();
            if (flamingStrike) {
                entity.func_70015_d(1);
            }
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(modifier);
            ToolHelper.attackEntity(stack, this, player, entity);
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(modifier);
            if (flamingStrike) {
                entity.func_70066_B();
            }
            world.func_184133_a(null, player.func_180425_c(), Sounds.frypan_boing, SoundCategory.PLAYERS, 1.5f, 0.6f + 0.2f * TConstruct.random.nextFloat());
            entity.func_70024_g(x, y, z);
            TinkerTools.proxy.spawnAttackParticle(Particles.FRYPAN_ATTACK, (Entity)player, 0.6);
            if (entity instanceof EntityPlayerMP) {
                TinkerNetwork.sendPacket(entity, new SPacketEntityVelocity(entity));
            }
        }
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit || player.func_130014_f_().field_72995_K) {
            player.func_184185_a(Sounds.frypan_boing, 2.0f, 1.0f);
        }
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.FRYPAN_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.7f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public float knockback() {
        return 2.0f;
    }

    @Override
    public double attackSpeed() {
        return 1.4;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        return this.buildDefaultTag(materials);
    }
}

