/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.ListUtil;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.entity.EntityBolt;
import slimeknights.tconstruct.tools.melee.item.Rapier;
import slimeknights.tconstruct.tools.ranged.item.BoltCore;
import slimeknights.tconstruct.tools.traits.TraitEnderference;

public class Bolt
extends ProjectileCore {
    protected final List<PartMaterialType> toolBuildComponents;

    public Bolt() {
        super(PartMaterialType.arrowShaft(TinkerTools.boltCore), new BoltHeadPartMaterialType(TinkerTools.boltCore), PartMaterialType.fletching(TinkerTools.fletching));
        this.addCategory(Category.NO_MELEE, Category.PROJECTILE);
        this.toolBuildComponents = ImmutableList.of((Object)this.requiredComponents[0], (Object)this.requiredComponents[2]);
    }

    @Override
    public List<PartMaterialType> getToolBuildComponents() {
        return this.toolBuildComponents;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Material head : TinkerRegistry.getAllMaterials()) {
                ArrayList<Material> mats = new ArrayList<Material>(3);
                if (!head.hasStats("head")) continue;
                mats.add(TinkerMaterials.wood);
                mats.add(head);
                mats.add(TinkerMaterials.feather);
                ItemStack tool = this.buildItem(mats);
                if (!this.hasValidMaterials(tool)) continue;
                subItems.add((Object)tool);
                if (Config.listAllToolMaterials) continue;
                break;
            }
        }
    }

    @Override
    public Material getMaterialForPartForGuiRendering(int index) {
        return super.getMaterialForPartForGuiRendering(index + 1);
    }

    @Override
    public ItemStack buildItemForRenderingInGui() {
        List<Material> materials = IntStream.range(0, this.getRequiredComponents().size()).mapToObj(x$0 -> super.getMaterialForPartForGuiRendering(x$0)).collect(Collectors.toList());
        return this.buildItemForRendering(materials);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public double attackSpeed() {
        return 1.0;
    }

    @Override
    @Nonnull
    public ItemStack buildItemFromStacks(NonNullList<ItemStack> inputStacks) {
        List stacks = inputStacks.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        if (stacks.size() != 2) {
            return ItemStack.field_190927_a;
        }
        ItemStack boltCore = (ItemStack)stacks.get(0);
        ItemStack fletching = (ItemStack)stacks.get(1);
        ItemStack boltCoreHead = BoltCore.getHeadStack(boltCore);
        return super.buildItemFromStacks(ListUtil.getListFrom(boltCore, boltCoreHead, fletching));
    }

    @Override
    public boolean dealDamageRanged(ItemStack stack, Entity projectile, EntityLivingBase player, Entity target, float damage) {
        if (target instanceof EntityEnderman && ((EntityEnderman)target).func_70660_b((Potion)TraitEnderference.Enderference) != null) {
            return target.func_70097_a((DamageSource)new ProjectileCore.DamageSourceProjectileForEndermen("arrow", projectile, (Entity)player), damage);
        }
        DamageSource damageSource = new EntityDamageSourceIndirect("arrow", projectile, (Entity)player).func_76349_b();
        return Rapier.dealHybridDamage(damageSource, target, damage);
    }

    @Override
    public ProjectileNBT buildTagData(List<Material> materials) {
        ProjectileNBT data = new ProjectileNBT();
        ArrowShaftMaterialStats shaft = (ArrowShaftMaterialStats)materials.get(0).getStatsOrUnknown("shaft");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        FletchingMaterialStats fletching = (FletchingMaterialStats)materials.get(2).getStatsOrUnknown("fletching");
        data.head(head);
        data.fletchings(fletching);
        data.shafts(this, shaft);
        data.durability = (int)((float)data.durability * 0.8f);
        return data;
    }

    @Override
    public EntityProjectileBase getProjectile(ItemStack stack, ItemStack bow, World world, EntityPlayer player, float speed, float inaccuracy, float power, boolean usedAmmo) {
        return new EntityBolt(world, player, speed, inaccuracy -= (1.0f - 1.0f / ProjectileNBT.from((ItemStack)stack).accuracy) * speed / 2.0f, power, this.getProjectileStack(stack, world, player, usedAmmo), bow);
    }

    private static class BoltHeadPartMaterialType
    extends PartMaterialType {
        public BoltHeadPartMaterialType(IToolPart part) {
            super(part, "head");
        }

        @Override
        public boolean isValidMaterial(Material material) {
            return material.isCastable() && super.isValidMaterial(material);
        }
    }
}

