/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.util.ChunkCoord;
import cofh.core.util.TimeTracker;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.GridFluidSuper;
import cofh.thermaldynamics.duct.fluid.PacketFluid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGridTracking;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;

public class GridFluid
extends MultiBlockGridTracking<DuctUnitFluid> {
    public final FluidTankGrid myTank = new FluidTankGrid(1000, this);
    public int toDistribute = 0;
    public boolean doesPassiveTicking = false;
    int numStorable = -1;
    public HashSet<ChunkCoord> chunks;
    TimeTracker myTracker = new TimeTracker();
    boolean recentRenderUpdate = false;
    int renderFluidLevel = 0;
    FluidStack myRenderFluid = null;

    public GridFluid(World world) {
        super(world);
    }

    @Override
    public void addBlock(DuctUnitFluid aMultiBlock) {
        super.addBlock(aMultiBlock);
        if (aMultiBlock.getFluidForGrid() != null) {
            if (this.myTank.getFluid() == null) {
                this.myTank.setFluid(aMultiBlock.getFluidForGrid());
            } else {
                this.myTank.fill(aMultiBlock.getFluidForGrid(), true);
            }
            aMultiBlock.setFluidForGrid(null);
            this.recentRenderUpdate = true;
        }
        if (this.renderFluidLevel != 0) {
            aMultiBlock.updateFluid();
        }
    }

    @Override
    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        super.addInfo(info, player, debug);
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            if (this instanceof GridFluidSuper) {
                this.addInfo(info, "fluidThroughput", new TextComponentTranslation("info.thermaldynamics.filter.zeroRetainSize", new Object[0]));
            } else {
                this.addInfo(info, "fluidThroughput", this.myTank.fluidThroughput);
            }
        }
    }

    @Override
    public void balanceGrid() {
        this.reworkNumberStorableDucts();
        this.myTank.setCapacity(this.size() * this.myTank.fluidPerDuct);
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.numStorable = -1;
        this.chunks = null;
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.numStorable = -1;
    }

    @Override
    protected int getLevel() {
        return this.myTank.getFluidAmount();
    }

    @Override
    protected String getUnit() {
        return "mB";
    }

    protected int getStorableNumberDucts() {
        int numBalancable = this.numStorable;
        if (numBalancable == -1) {
            numBalancable = this.reworkNumberStorableDucts();
        }
        return numBalancable;
    }

    private int reworkNumberStorableDucts() {
        int numBalancable = 0;
        for (DuctUnitFluid duct : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
            if (!duct.canStoreFluid()) continue;
            ++numBalancable;
        }
        this.numStorable = numBalancable;
        return numBalancable;
    }

    public float getThroughPutModifier() {
        return 1.0f;
    }

    public int getMaxFluidPerDuct() {
        return 3000;
    }

    @Override
    public void destroyNode(IGridTile node) {
        if (this.hasValidFluid()) {
            ((DuctUnitFluid)node).setFluidForGrid(this.getNodeShare((DuctUnitFluid)node));
        }
        super.destroyNode(node);
    }

    @Override
    public void tickGrid() {
        block11: {
            DuctUnitFluid m;
            Iterator iterator;
            super.tickGrid();
            if (this.worldGrid.worldObj.func_82737_E() % 4L == 0L) {
                this.updateAllRenders();
            }
            if (this.myTank.getFluid() != null && this.nodeSet.size() > 0) {
                this.toDistribute = Math.min(this.myTank.getFluidAmount() / this.size(), this.getFluidThroughput());
                if (this.toDistribute <= 0) {
                    this.toDistribute = Math.min(this.myTank.getFluidAmount() % this.size(), this.getFluidThroughput());
                }
                if (this.toDistribute > 0) {
                    iterator = this.nodeSet.iterator();
                    while (iterator.hasNext() && (m = (DuctUnitFluid)iterator.next()).tickPass(0) && m.getGrid() != null) {
                    }
                }
            }
            if (!this.nodeSet.isEmpty()) {
                iterator = this.nodeSet.iterator();
                while (iterator.hasNext() && (m = (DuctUnitFluid)iterator.next()).tickPass(1) && m.getGrid() != null) {
                }
            }
            if (!this.doesPassiveTicking) break block11;
            if (!this.nodeSet.isEmpty()) {
                iterator = this.nodeSet.iterator();
                while (iterator.hasNext() && (m = (DuctUnitFluid)iterator.next()).tickPass(2) && m.getGrid() != null) {
                }
            }
            if (!this.idleSet.isEmpty()) {
                iterator = this.idleSet.iterator();
                while (iterator.hasNext() && (m = (DuctUnitFluid)iterator.next()).tickPass(2) && m.getGrid() != null) {
                }
            }
        }
    }

    @Override
    public void mergeGrids(MultiBlockGrid<DuctUnitFluid> theGrid) {
        super.mergeGrids(theGrid);
        GridFluid gridFluid = (GridFluid)theGrid;
        this.doesPassiveTicking = this.doesPassiveTicking || gridFluid.doesPassiveTicking;
        this.myTank.fill(gridFluid.getFluid(), true);
        this.recentRenderUpdate = true;
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return aBlock instanceof DuctUnitFluid && FluidHelper.isFluidEqualOrNull((FluidStack)((DuctUnitFluid)aBlock).getConnectionFluid(), (FluidStack)this.myTank.getFluid());
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid grid) {
        return super.canGridsMerge(grid) && FluidHelper.isFluidEqualOrNull((FluidStack)((GridFluid)grid).getFluid(), (FluidStack)this.getFluid());
    }

    public int getFluidThroughput() {
        if (this.myTank.getFluid() == null) {
            return 100;
        }
        int capacity = this.myTank.getCapacity();
        if (this.myTank.getFluid().amount >= capacity * 3 / 4) {
            return this.myTank.fluidThroughput;
        }
        if (this.myTank.getFluid().amount <= capacity / 4) {
            return this.myTank.fluidThroughput >> 1;
        }
        return (this.myTank.fluidThroughput >> 1) + (this.myTank.fluidThroughput >> 1) * (this.myTank.getFluid().amount - (capacity >> 2)) / (capacity >> 1);
    }

    public void fluidChanged() {
        this.balanceGrid();
    }

    @Nullable
    public FluidStack getNodeShare(DuctUnitFluid duct) {
        if (!duct.canStoreFluid()) {
            return null;
        }
        FluidStack fluid = this.myTank.getFluid();
        if (fluid == null) {
            return null;
        }
        FluidStack toReturn = fluid.copy();
        toReturn.amount = this.getNodeAmount(duct);
        return toReturn.amount > 0 ? toReturn : null;
    }

    public int getNodeAmount(DuctUnitFluid duct) {
        if (!duct.canStoreFluid()) {
            return 0;
        }
        int size = this.getStorableNumberDucts();
        if (size == 0) {
            return 0;
        }
        return size == 1 ? this.myTank.getFluidAmount() : (this.isFirstMultiblock(duct) ? this.myTank.getFluidAmount() / size + this.myTank.getFluidAmount() % size : this.myTank.getFluidAmount() / size);
    }

    public FluidStack getFluid() {
        return this.myTank.getFluid();
    }

    public boolean hasValidFluid() {
        return this.myTank.getFluid() != null;
    }

    public void buildMap() {
        this.chunks = new HashSet();
        for (DuctUnitFluid iMultiBlock : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
            this.buildMapEntry(iMultiBlock);
        }
    }

    private void buildMapEntry(DuctUnitFluid iMultiBlock) {
        this.chunks.add(new ChunkCoord(iMultiBlock.x() >> 4, iMultiBlock.z() >> 4));
    }

    public void updateAllRenders() {
        int fl = this.renderFluidLevel;
        if (this.updateRender() && fl != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
            if (this.chunks == null) {
                this.buildMap();
            }
            if (this.worldGrid.worldObj instanceof WorldServer) {
                int ducts = 0;
                for (DuctUnitFluid block : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
                    if (block.isOpaque()) continue;
                    ++ducts;
                    block.updateLighting();
                }
                if (ducts != 0) {
                    PacketFluid packet = new PacketFluid(this, ducts);
                    WorldServer dimension = (WorldServer)this.worldGrid.worldObj;
                    block1: for (EntityPlayer player : dimension.field_73010_i) {
                        for (ChunkCoord chunk : this.chunks) {
                            int dz;
                            int dx = (chunk.chunkX - (MathHelper.floor((double)player.field_70165_t) >> 4)) * 16;
                            if (dx * dx + (dz = (chunk.chunkZ - (MathHelper.floor((double)player.field_70161_v) >> 4)) * 16) * dz > 36864) continue;
                            PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    public boolean updateRender() {
        if (this.recentRenderUpdate && this.myTracker.hasDelayPassed(this.worldGrid.worldObj, 96)) {
            this.recentRenderUpdate = false;
        }
        if (this.myTank.getFluid() != null && this.myTank.getCapacity() > 0) {
            double fullPercent = 10000 * this.myTank.getFluid().amount / this.myTank.getCapacity();
            if (fullPercent >= 0.0) {
                int n = this.renderFluidLevel == 2 ? 500 : 700;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 1;
                    return true;
                }
            }
            if (fullPercent >= 500.0) {
                int n = this.renderFluidLevel == 3 ? 2000 : 2500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 2;
                    return true;
                }
            }
            if (fullPercent >= 2000.0) {
                int n = this.renderFluidLevel == 4 ? 4000 : 4500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 3;
                    return true;
                }
            }
            if (fullPercent >= 4000.0) {
                int n = this.renderFluidLevel == 5 ? 6000 : 6500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 4;
                    return true;
                }
            }
            if (fullPercent >= 6000.0) {
                int n = this.renderFluidLevel == 6 ? 8000 : 8500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 5;
                    return true;
                }
            }
            this.renderFluidLevel = 6;
            return true;
        }
        if (this.renderFluidLevel != 0 && !this.recentRenderUpdate) {
            this.renderFluidLevel = 0;
            this.recentRenderUpdate = true;
            this.myTracker.markTime(this.worldGrid.worldObj);
            return true;
        }
        return false;
    }

    public FluidStack getRenderFluid() {
        return this.myRenderFluid;
    }

    public FluidStack getConnectionFluid() {
        int fl = this.renderFluidLevel;
        if (this.updateRender() && fl != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
        }
        return this.myRenderFluid;
    }

    public int getRenderLevel() {
        return this.renderFluidLevel;
    }

    public static final class FluidRenderType {
        public static final byte EMPTY = 0;
        public static final byte LOW = 1;
        public static final byte LOW_MED = 2;
        public static final byte MEDIUM = 3;
        public static final byte MED_HIGH = 4;
        public static final byte HIGH = 5;
        public static final byte FULL = 6;
    }
}

