/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.plugins.jei;

import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.item.ItemCover;
import cofh.thermaldynamics.plugins.jei.CoverRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CoverRecipeCategory
extends BlankRecipeCategory<CoverRecipeWrapper> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawableStatic background;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public static void register(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoverRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        registry.addRecipes(CoverRecipeCategory.getRecipes(), "thermaldynamics.covers");
        registry.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150462_ai), new String[]{"thermaldynamics.covers"});
    }

    public static List<CoverRecipeWrapper> getRecipes() {
        LinkedList<CoverRecipeWrapper> recipes = new LinkedList<CoverRecipeWrapper>();
        for (ItemStack stack : ItemCover.getCoverList()) {
            recipes.add(new CoverRecipeWrapper(stack));
        }
        return recipes;
    }

    public CoverRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/crafting_table.png");
        this.background = guiHelper.createDrawable(location, 29, 16, 116, 54);
        this.localizedName = StringHelper.localize((String)"recipe.thermaldynamics.covers");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return "thermaldynamics.covers";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "ThermalDynamics";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CoverRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        this.craftingGridHelper.setInputStacks(guiItemStacks, ingredients.getInputs(ItemStack.class));
        guiItemStacks.set(0, (List)ingredients.getOutputs(ItemStack.class).get(0));
    }
}

