/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.CommonProxy;
import com.gildedgames.the_aether.client.AetherClientEvents;
import com.gildedgames.the_aether.client.AetherKeybinds;
import com.gildedgames.the_aether.client.audio.AetherMusicHandler;
import com.gildedgames.the_aether.client.gui.GuiAetherInGame;
import com.gildedgames.the_aether.client.gui.GuiSunAltar;
import com.gildedgames.the_aether.client.gui.toast.GuiAetherToast;
import com.gildedgames.the_aether.client.renders.AetherEntityRenderingRegistry;
import com.gildedgames.the_aether.client.renders.blocks.BlockRendering;
import com.gildedgames.the_aether.client.renders.items.ItemRendering;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInitialization() {
        GuiAetherToast.overrideToastGui();
        ClientProxy.registerEvent(new BlockRendering());
        ClientProxy.registerEvent(new ItemRendering());
        AetherEntityRenderingRegistry.initialize();
        MinecraftForge.EVENT_BUS.register((Object)new AetherClientEvents());
    }

    @Override
    public void initialization() {
        this.generateTexturePack();
        BlockRendering.registerColors();
        ItemRendering.registerColors();
        AetherEntityRenderingRegistry.initializePlayerLayers();
        AetherKeybinds.initialization();
        MinecraftForge.EVENT_BUS.register((Object)new GuiAetherInGame(Minecraft.func_71410_x()));
        ClientProxy.registerEvent(new AetherMusicHandler());
    }

    public void generateTexturePack() {
        try {
            File resourcePacks = Minecraft.func_71410_x().func_110438_M().func_110612_e().getCanonicalFile();
            File buckets = new File(resourcePacks + "/Aether b1.7.3 Textures/assets/aether_legacy/textures/items/misc/buckets");
            File weapons = new File(resourcePacks + "/Aether b1.7.3 Textures/assets/aether_legacy/textures/items/weapons");
            File armor = new File(resourcePacks + "/Aether b1.7.3 Textures/assets/aether_legacy/textures/items/armor");
            File accessories = new File(resourcePacks + "/Aether b1.7.3 Textures/assets/aether_legacy/textures/items/accessories");
            File[] directories = new File[]{buckets, weapons, armor, accessories};
            if (AetherConfig.visual_options.install_resourcepack) {
                for (File file : directories) {
                    if (file.exists()) continue;
                    file.mkdirs();
                }
                this.generateFile("data/Aether_b1.7.3/pack.mcmeta", "pack.mcmeta", resourcePacks.getAbsolutePath() + "/Aether b1.7.3 Textures");
                this.generateFile("data/Aether_b1.7.3/pack.png", "pack.png", resourcePacks.getAbsolutePath() + "/Aether b1.7.3 Textures");
                this.generateFile("data/Aether_b1.7.3/skyroot_remedy_bucket.png", "skyroot_remedy_bucket.png", buckets.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/bow_pulling_0.png", "bow_pulling_0.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/bow_pulling_1.png", "bow_pulling_1.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/bow_pulling_2.png", "bow_pulling_2.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/flaming_sword.png", "flaming_sword.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/holy_sword.png", "holy_sword.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/lightning_sword.png", "lightning_sword.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/weapons/phoenix_bow.png", "phoenix_bow.png", weapons.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/armor/phoenix_boots.png", "phoenix_boots.png", armor.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/armor/phoenix_leggings.png", "phoenix_leggings.png", armor.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/armor/phoenix_chestplate.png", "phoenix_chestplate.png", armor.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/armor/phoenix_helmet.png", "phoenix_helmet.png", armor.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/accessories/phoenix_gloves.png", "phoenix_gloves.png", accessories.getAbsolutePath());
                this.generateFile("data/Aether_b1.7.3/accessories/agility_cape.png", "agility_cape.png", accessories.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void generateFile(String input, String name, String path) {
        try {
            File file = new File(path + "/" + name);
            if (!file.exists()) {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(input);
                FileOutputStream outputStream = new FileOutputStream(file);
                if (inputStream != null) {
                    int i;
                    while ((i = inputStream.read()) != -1) {
                        outputStream.write(i);
                    }
                    inputStream.close();
                    outputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void postInitialization() {
    }

    @Override
    public void sendMessage(EntityPlayer reciever, ITextComponent message) {
        if (this.getThePlayer() == reciever) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(message);
        }
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void spawnSmoke(World world, BlockPos pos) {
        Random rand = new Random();
        double a = (double)pos.func_177958_n() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * 0.375;
        double b = (double)pos.func_177956_o() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * 0.375;
        double c = (double)pos.func_177952_p() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * 0.375;
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, a, b, c, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public void spawnSplode(World world, double x, double y, double z) {
        Random rand = new Random();
        double var2 = (rand.nextFloat() - 0.5f) * 0.5f;
        double var4 = (rand.nextFloat() - 0.5f) * 0.5f;
        double var6 = (rand.nextFloat() - 0.5f) * 0.5f;
        world.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, x, y, z, var2 *= 0.5, (var4 *= 0.5) + 0.125, var6 *= 0.5, new int[0]);
    }

    @Override
    public void spawnBlockBrokenFX(IBlockState state, BlockPos pos) {
        FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, state);
    }

    @Override
    public void openSunAltar() {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSunAltar());
    }
}

