/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.gui;

import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.client.overlay.AetherOverlay;
import com.gildedgames.the_aether.player.PlayerAether;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiAetherInGame
extends Gui {
    private Minecraft mc;

    public GuiAetherInGame(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        IPlayerAether player;
        if (this.mc.field_71439_g != null && (player = AetherAPI.getInstance().get((EntityPlayer)this.mc.field_71439_g)).getAccessoryInventory().isWearingPhoenixSet() && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent event) {
        float portalTime;
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        IPlayerAether player = AetherAPI.getInstance().get((EntityPlayer)this.mc.field_71439_g);
        if (player.getEntity() != null) {
            AetherOverlay.renderCure(this.mc);
            AetherOverlay.renderPoison(this.mc);
            AetherOverlay.renderIronBubble(this.mc);
            AetherOverlay.renderCooldown(this.mc);
            AetherOverlay.renderJumps(this.mc);
            AetherOverlay.renderBossHP(this.mc);
        }
        if ((portalTime = ((PlayerAether)player).portalAnimTime * 1.2f + (((PlayerAether)player).prevPortalAnimTime - ((PlayerAether)player).portalAnimTime)) > 0.0f && portalTime > 0.0f) {
            AetherOverlay.renderAetherPortal(portalTime, new ScaledResolution(this.mc));
        }
    }
}

