/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.networking.AetherNetworkingManager;
import com.gildedgames.the_aether.networking.packets.PacketSendEternalDay;
import com.gildedgames.the_aether.networking.packets.PacketSendShouldCycle;
import com.gildedgames.the_aether.networking.packets.PacketSendTime;
import com.gildedgames.the_aether.world.AetherBiomeProvider;
import com.gildedgames.the_aether.world.AetherWorld;
import com.gildedgames.the_aether.world.ChunkProviderAether;
import com.gildedgames.the_aether.world.EternalDayManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;

public class AetherWorldProvider
extends WorldProvider {
    private float[] colorsSunriseSunset = new float[4];
    private EternalDayManager eternalDayManager;
    private boolean eternalDay;
    private boolean shouldCycleCatchup;
    private long aetherTime = 6000L;

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76578_c = new AetherBiomeProvider(this.field_76579_a.func_72905_C());
        NBTTagCompound nbttagcompound = this.field_76579_a.func_72912_H().getDimensionData(AetherConfig.dimension.aether_dimension_id);
        this.eternalDayManager = this.field_76579_a instanceof WorldServer ? new EternalDayManager((WorldServer)this.field_76579_a, nbttagcompound.func_74775_l("EternalDay")) : null;
    }

    public float[] func_76560_a(float f, float f1) {
        float f4;
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(f * 3.141593f * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            this.colorsSunriseSunset[0] = f5 * 0.3f + 0.1f;
            this.colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f5 * f5 * 0.7f + 0.2f;
            this.colorsSunriseSunset[3] = f6;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public boolean func_76566_a(int i, int j) {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        try {
            if (player.field_71093_bK == AetherConfig.dimension.aether_dimension_id && EntityPlayer.func_180467_a((World)player.field_70170_p, (BlockPos)player.getBedLocation(AetherConfig.dimension.aether_dimension_id), (boolean)false) != null) {
                return AetherConfig.dimension.aether_dimension_id;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkProviderAether(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public Vec3d func_76562_b(float f, float f1) {
        int i = 9671612;
        float f2 = MathHelper.func_76134_b((float)(f * 3.141593f * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(i & 0xFF) / 255.0f;
        return new Vec3d((double)(f3 *= f2 * 0.94f + 0.06f), (double)(f4 *= f2 * 0.94f + 0.06f), (double)(f5 *= f2 * 0.91f + 0.09f));
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        int i;
        float f;
        if (!AetherConfig.gameplay_changes.disable_eternal_day && this.eternalDayManager != null && !this.eternalDayManager.isEternalDay()) {
            if (this.eternalDayManager.shouldCycleCatchup()) {
                if (this.eternalDayManager.getTime() != worldTime % 24000L && this.eternalDayManager.getTime() != worldTime + 1L && this.eternalDayManager.getTime() != worldTime - 1L) {
                    this.eternalDayManager.setTime(Math.floorMod(this.eternalDayManager.getTime() - 1L, 24000L));
                } else {
                    this.eternalDayManager.setShouldCycleCatchup(false);
                }
            } else {
                this.eternalDayManager.setTime(worldTime);
            }
            this.aetherTime = this.eternalDayManager.getTime();
            AetherNetworkingManager.sendToAll(new PacketSendTime(this.aetherTime));
            this.eternalDayManager.setTime(this.aetherTime);
        }
        if ((f = ((float)(i = (int)((AetherConfig.gameplay_changes.disable_eternal_day ? worldTime : this.aetherTime) % 24000L)) + partialTicks) / 24000.0f - 0.25f) < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    public void setIsEternalDay(boolean set) {
        this.eternalDay = set;
    }

    public boolean getIsEternalDay() {
        return this.eternalDay;
    }

    public void setShouldCycleCatchup(boolean set) {
        this.shouldCycleCatchup = set;
    }

    public boolean getShouldCycleCatchup() {
        return this.shouldCycleCatchup;
    }

    public void setAetherTime(long time) {
        this.aetherTime = time;
    }

    public long getAetherTime() {
        return this.aetherTime;
    }

    public String getSaveFolder() {
        return "Dim-Aether";
    }

    public double func_76565_k() {
        return 100.0;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 0.0;
    }

    public float func_76571_f() {
        return -5.0f;
    }

    public DimensionType func_186058_p() {
        return AetherWorld.aether_dimension_type;
    }

    public void func_186057_q() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (this.eternalDayManager != null) {
            nbttagcompound.func_74782_a("EternalDay", (NBTBase)this.eternalDayManager.getCompound());
        }
        this.field_76579_a.func_72912_H().setDimensionData(AetherConfig.dimension.aether_dimension_id, nbttagcompound);
    }

    public void func_186059_r() {
        if (this.eternalDayManager != null) {
            this.eternalDay = this.eternalDayManager.isEternalDay();
            AetherNetworkingManager.sendToAll(new PacketSendEternalDay(this.eternalDay));
            this.shouldCycleCatchup = this.eternalDayManager.shouldCycleCatchup();
            AetherNetworkingManager.sendToAll(new PacketSendShouldCycle(this.shouldCycleCatchup));
        }
    }

    public EternalDayManager getEternalDayManager() {
        return this.eternalDayManager;
    }
}

