/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.biome;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.util.EnumCloudType;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenClouds;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenDungeonOakTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenFloatingIsland;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenFoilage;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenHolidayTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenLakes;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenLiquids;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenOakTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenQuicksoil;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenSkyrootTree;
import java.util.Calendar;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AetherBiomeDecorator
extends BiomeDecorator {
    public World world;
    public Random rand;
    public Biome aetherBiome;
    public AetherGenClouds clouds = new AetherGenClouds();
    public AetherGenFoilage foilage = new AetherGenFoilage();
    public WorldGenMinable aetherDirtGen = new WorldGenMinable(BlocksAether.aether_dirt.func_176223_P(), 32, stateIn -> stateIn.func_177230_c() == BlocksAether.holystone);
    public WorldGenMinable icestoneGen = new WorldGenMinable(BlocksAether.icestone.func_176223_P(), 16, stateIn -> stateIn.func_177230_c() == BlocksAether.holystone);
    public WorldGenMinable ambrosiumGen = new WorldGenMinable(BlocksAether.ambrosium_ore.func_176223_P(), 16, stateIn -> stateIn.func_177230_c() == BlocksAether.holystone);
    public WorldGenMinable zaniteGen = new WorldGenMinable(BlocksAether.zanite_ore.func_176223_P(), 8, stateIn -> stateIn.func_177230_c() == BlocksAether.holystone);
    public WorldGenMinable gravititeGen = new WorldGenMinable(BlocksAether.gravitite_ore.func_176223_P(), 6, stateIn -> stateIn.func_177230_c() == BlocksAether.holystone);
    public AetherGenSkyrootTree skyroot_tree = new AetherGenSkyrootTree(false);
    public AetherGenDungeonOakTree golden_oak_tree_dungeon = new AetherGenDungeonOakTree();
    public AetherGenQuicksoil quicksoil_patches = new AetherGenQuicksoil();
    public AetherGenFloatingIsland crystal_island = new AetherGenFloatingIsland();
    public AetherGenLiquids liquid_overhang = new AetherGenLiquids();
    public AetherGenHolidayTree holiday_tree = new AetherGenHolidayTree();
    public AetherGenLakes aether_lakes = new AetherGenLakes();
    public WorldGenDoublePlant doubleGrass = new WorldGenDoublePlant();

    public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
        this.doubleGrass.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180294_c = pos;
        this.world = worldIn;
        this.rand = random;
        this.aetherBiome = biome;
        this.func_150513_a(biome, worldIn, random);
        this.field_185425_a = false;
    }

    protected void func_150513_a(Biome biomeGenBaseIn, World worldIn, Random random) {
        int i;
        ChunkPos pos = new ChunkPos(this.field_180294_c);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(worldIn, random, pos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, random, this.field_180294_c));
        if (this.shouldSpawn(3) && TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.aetherDirtGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.spawnOre(this.aetherDirtGen, 20, 128);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.icestoneGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.spawnOre(this.icestoneGen, 10, 128);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.ambrosiumGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.spawnOre(this.ambrosiumGen, 15, 128);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.zaniteGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.spawnOre(this.zaniteGen, 12, 128);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.gravititeGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.spawnOre(this.gravititeGen, 8, 128);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, random, this.field_180294_c));
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            if (AetherConfig.world_gen.pink_aerclouds || Loader.isModLoaded((String)"lost_aether")) {
                this.generateClouds(EnumCloudType.Pink, 1, 50, this.nextInt(64) + 110);
            }
            this.generateClouds(EnumCloudType.Golden, 4, 50, this.nextInt(64) + 96);
            this.generateClouds(EnumCloudType.Blue, 8, 26, this.nextInt(64) + 32);
            this.generateClouds(EnumCloudType.Cold, 16, 14, this.nextInt(64) + 64);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            this.generateFoilage(BlocksAether.white_flower.func_176223_P());
            this.generateFoilage(BlocksAether.purple_flower.func_176223_P());
            this.generateFoilage(BlocksAether.berry_bush.func_176223_P());
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            if (this.shouldSpawn(2)) {
                this.getTree().func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(16) + 8, 0, this.nextInt(16) + 8)));
            }
            if (this.shouldSpawn(1)) {
                this.skyroot_tree.func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(8) + 8, 0, this.nextInt(8) + 8)));
            }
            if (this.shouldSpawn(37)) {
                this.crystal_island.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(8, this.nextInt(64) + 32, 8));
            }
            for (i = 0; i < 20; ++i) {
                this.golden_oak_tree_dungeon.func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(16), 0, this.nextInt(16))));
            }
            if ((AetherConfig.world_gen.christmas_time || AetherConfig.world_gen.seasonal_christmas && (Calendar.getInstance().get(2) + 1 == 12 || Calendar.getInstance().get(2) + 1 == 1)) && this.shouldSpawn(15)) {
                this.holiday_tree.func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c));
            }
        }
        if (AetherConfig.world_gen.tallgrass_enabled && TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int i3 = 0; i3 < 10; ++i3) {
                int i11;
                int j7 = random.nextInt(16) + 8;
                int k14 = worldIn.func_175645_m(this.field_180294_c.func_177982_a(j7, 0, i11 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (k14 <= 0) continue;
                int l17 = random.nextInt(k14);
                biomeGenBaseIn.func_76730_b(random).func_180709_b(worldIn, random, this.field_180294_c.func_177982_a(j7, l17, i11));
            }
            for (i = 0; i < 7; ++i) {
                int j = random.nextInt(16) + 8;
                int k = random.nextInt(16) + 8;
                int l = random.nextInt(worldIn.func_175645_m(this.field_180294_c.func_177982_a(j, 0, k)).func_177956_o() + 32);
                this.doubleGrass.func_180709_b(worldIn, random, this.field_180294_c.func_177982_a(j, l, k));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.shouldSpawn(10)) {
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(worldIn, random, pos));
    }

    public int nextInt(int max) {
        return this.rand.nextInt(max);
    }

    public boolean shouldSpawn(int chance) {
        return this.nextInt(chance) == 0;
    }

    public WorldGenerator getTree() {
        return this.shouldSpawn(13) ? new AetherGenOakTree() : new AetherGenSkyrootTree(true);
    }

    public void generateFoilage(IBlockState block) {
        this.foilage.setPlantBlock(block);
        for (int n = 0; n < 2; ++n) {
            this.foilage.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16) + 8, this.nextInt(128), this.nextInt(16) + 8));
        }
    }

    public void generateClouds(EnumCloudType type, int amount, int chance, int y) {
        if (this.shouldSpawn(chance)) {
            this.clouds.setAmount(amount);
            this.clouds.setCloudType(type);
            this.clouds.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(0, y, 0));
        }
    }

    public void spawnOre(WorldGenMinable gen, int chance, int y) {
        for (int chances = 0; chances < chance; ++chances) {
            gen.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16), this.nextInt(y), this.nextInt(16)));
        }
    }
}

