/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.core.features.ActivityState;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlockStackSrc
implements IStackSrc {
    private final Block block;
    private final int damage;
    private final boolean enabled;

    public BlockStackSrc(Block block, int damage, ActivityState state) {
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkArgument((state == ActivityState.Enabled || state == ActivityState.Disabled ? 1 : 0) != 0);
        this.block = block;
        this.damage = damage;
        this.enabled = state == ActivityState.Enabled;
    }

    @Override
    @Nullable
    public ItemStack stack(int i) {
        return new ItemStack(this.block, i, this.damage);
    }

    @Override
    public Item getItem() {
        return null;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

